/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.config;

import be.atbash.config.AbstractConfiguration;
import be.atbash.config.exception.ConfigurationException;
import be.atbash.config.logging.ConfigEntry;
import be.atbash.config.logging.ModuleConfig;
import be.atbash.config.logging.ModuleConfigName;
import be.atbash.config.logging.StartupLogging;
import be.atbash.ee.security.octopus.config.PemKeyEncryption;
import be.atbash.ee.security.octopus.keys.KeyManager;
import be.atbash.ee.security.octopus.keys.LocalKeyManager;
import be.atbash.ee.security.octopus.keys.reader.DefaultKeyResourceTypeProvider;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceTypeProvider;
import be.atbash.ee.security.octopus.keys.reader.password.ConfigKeyResourcePasswordLookup;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import be.atbash.util.StringUtils;
import be.atbash.util.reflection.CDICheck;
import be.atbash.util.reflection.ClassUtils;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
@ModuleConfigName(value="Octopus JWT Support Configuration")
public class JwtSupportConfiguration
extends AbstractConfiguration
implements ModuleConfig {
    private static final List<JWSAlgorithm> RSA_SUPPORTED_ALGOS = Arrays.asList(JWSAlgorithm.RS256, JWSAlgorithm.RS384, JWSAlgorithm.RS512, JWSAlgorithm.PS256, JWSAlgorithm.PS384, JWSAlgorithm.PS512);
    private static JwtSupportConfiguration INSTANCE;

    @ConfigEntry
    public String getKeysLocation() {
        return (String)this.getOptionalValue("keys.location", String.class);
    }

    @ConfigEntry
    public KeyResourcePasswordLookup getPasswordLookup() {
        String passwordClass = (String)this.getOptionalValue("lookup.password.class", ConfigKeyResourcePasswordLookup.class.getName(), String.class);
        if (StringUtils.isEmpty((String)passwordClass)) {
            throw new ConfigurationException("Configuration parameter lookup.password.class is required to have a value.");
        }
        if (!ClassUtils.isAvailable((String)passwordClass)) {
            throw new ConfigurationException("Configuration parameter lookup.password.class class not found.");
        }
        Class passwordClz = ClassUtils.forName((String)passwordClass);
        if (!KeyResourcePasswordLookup.class.isAssignableFrom(passwordClz)) {
            throw new ConfigurationException("Configuration parameter lookup.password.class must be an implementation of be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup");
        }
        return (KeyResourcePasswordLookup)ClassUtils.newInstance((Class)passwordClz);
    }

    @ConfigEntry
    public KeyManager getKeyManager() {
        String keyManagerClass = (String)this.getOptionalValue("key.manager.class", LocalKeyManager.class.getName(), String.class);
        if (StringUtils.isEmpty((String)keyManagerClass)) {
            throw new ConfigurationException("Configuration parameter key.manager.class is required to have a value.");
        }
        if (!ClassUtils.isAvailable((String)keyManagerClass)) {
            throw new ConfigurationException("Configuration parameter key.manager.class class not found.");
        }
        Class keyManagerClz = ClassUtils.forName((String)keyManagerClass);
        if (!KeyManager.class.isAssignableFrom(keyManagerClz)) {
            throw new ConfigurationException("Configuration parameter key.manager.class must be an implementation of be.atbash.ee.security.octopus.keys.KeyManager");
        }
        return (KeyManager)ClassUtils.newInstance((Class)keyManagerClz);
    }

    @ConfigEntry
    public KeyResourceTypeProvider getKeyResourceTypeProvider() {
        String keyResourceTypeProviderClass = (String)this.getOptionalValue("key.resourcetype.provider.class", DefaultKeyResourceTypeProvider.class.getName(), String.class);
        if (StringUtils.isEmpty((String)keyResourceTypeProviderClass)) {
            throw new ConfigurationException("Configuration parameter key.resourcetype.provider.class is required to have a value.");
        }
        if (!ClassUtils.isAvailable((String)keyResourceTypeProviderClass)) {
            throw new ConfigurationException("Configuration parameter key.resourcetype.provider.class class not found.");
        }
        Class keyResourceTypeProviderClz = ClassUtils.forName((String)keyResourceTypeProviderClass);
        if (!KeyResourceTypeProvider.class.isAssignableFrom(keyResourceTypeProviderClz)) {
            throw new ConfigurationException("Configuration parameter key.resourcetype.provider.class must be an implementation of be.atbash.ee.security.octopus.keys.reader.KeyResourceTypeProvider");
        }
        return (KeyResourceTypeProvider)ClassUtils.newInstance((Class)keyResourceTypeProviderClz);
    }

    @ConfigEntry
    public PemKeyEncryption getPemKeyEncryption() {
        try {
            return (PemKeyEncryption)((Object)this.getOptionalValue("key.pem.encryption", (Object)PemKeyEncryption.PKCS8, PemKeyEncryption.class));
        }
        catch (IllegalArgumentException e) {
            String stringValue = (String)this.getOptionalValue("key.pem.encryption", "", String.class);
            if (StringUtils.isEmpty((String)stringValue)) {
                return PemKeyEncryption.NONE;
            }
            throw new ConfigurationException("Configuration parameter key.pem.encryption must be PKCS8 or PKCS1");
        }
    }

    @ConfigProperty
    public String getPKCS1EncryptionAlgorithm() {
        return (String)this.getOptionalValue("key.pem.pkcs1.encryption", "DES-EDE3-CBC", String.class);
    }

    @ConfigProperty
    public String getNameCertificateKeyStore() {
        return (String)this.getOptionalValue("key.store.certificate.x500name", "CN=localhost", String.class);
    }

    @ConfigProperty
    public String getCertificateSignatureAlgorithm() {
        return (String)this.getOptionalValue("key.store.signature.algo", "SHA1WithRSA", String.class);
    }

    @ConfigProperty
    public String getKeyStoreType() {
        return (String)this.getOptionalValue("key.store.type", "pkcs12", String.class);
    }

    @ConfigProperty
    public JWSAlgorithm getJWSAlgorithmForRSA() {
        String value = (String)this.getOptionalValue("jwt.sign.rsa.algo", "RS256", String.class);
        JWSAlgorithm result = null;
        for (JWSAlgorithm algo : RSA_SUPPORTED_ALGOS) {
            if (!algo.getName().equals(value)) continue;
            result = algo;
        }
        if (result == null) {
            throw new ConfigurationException(String.format("Unsupported algorithm name %s for RSA signing", value));
        }
        return result;
    }

    public static synchronized JwtSupportConfiguration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JwtSupportConfiguration();
            if (!CDICheck.withinContainer()) {
                StartupLogging.logConfiguration((ModuleConfig)INSTANCE);
            }
        }
        return INSTANCE;
    }
}

