/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.parameter;

import be.atbash.ee.security.octopus.jwt.JWTEncoding;
import be.atbash.ee.security.octopus.jwt.keys.SecretKeyType;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParameters;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersEncryption;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersNone;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersSigning;
import be.atbash.util.exception.AtbashIllegalActionException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JWTParametersBuilder {
    private Logger logger = LoggerFactory.getLogger(JWTParametersBuilder.class);
    private JWTEncoding encoding;
    private Map<String, Object> headerValues;
    private JWK secretKeySigning;
    private SecretKeyType secretKeyType;
    private JWK secretKeyEncryption;
    private JWTParametersSigning parametersSigning;

    private JWTParametersBuilder(JWTEncoding encoding) {
        this.encoding = encoding;
    }

    public JWTParametersBuilder withHeader(String key, String value) {
        if (this.encoding == JWTEncoding.NONE) {
            this.logger.warn("Header values are not supported with JWTEncoding.NONE");
        }
        if (this.headerValues == null) {
            this.headerValues = new HashMap<String, Object>();
        }
        this.headerValues.put(key, value);
        return this;
    }

    public JWTParametersBuilder withSecretKeyForSigning(JWK key) {
        if (this.encoding == JWTEncoding.NONE) {
            this.logger.warn("SecretKey value is not supported with JWTEncoding.NONE");
        }
        this.secretKeySigning = key;
        this.determineSecretKeyType();
        return this;
    }

    private void determineSecretKeyType() {
        if (KeyType.OCT.equals((Object)this.secretKeySigning.getKeyType())) {
            this.secretKeyType = SecretKeyType.HMAC;
        }
        if (KeyType.RSA.equals((Object)this.secretKeySigning.getKeyType())) {
            this.secretKeyType = SecretKeyType.RSA;
        }
        if (KeyType.EC.equals((Object)this.secretKeySigning.getKeyType())) {
            this.secretKeyType = SecretKeyType.EC;
        }
    }

    public JWTParametersBuilder withSecretKeyForEncryption(JWK key) {
        if (this.encoding != JWTEncoding.JWE) {
            this.logger.warn("SecretKey value for encryption only needed for JWTEncoding.JWE");
        }
        this.secretKeyEncryption = key;
        return this;
    }

    public JWTParametersBuilder withSigningParameters(JWTParametersSigning parametersSigning) {
        this.parametersSigning = parametersSigning;
        return this;
    }

    public JWTParameters build() {
        JWTParameters result;
        this.validateParameters();
        switch (this.encoding) {
            case NONE: {
                result = new JWTParametersNone();
                break;
            }
            case JWS: {
                result = new JWTParametersSigning(this.headerValues, this.secretKeyType, this.secretKeySigning);
                break;
            }
            case JWE: {
                result = new JWTParametersEncryption(this.parametersSigning, this.headerValues, this.secretKeyEncryption);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported value for JWTEncoding : %s", new Object[]{this.encoding}));
            }
        }
        return result;
    }

    private void validateParameters() {
        switch (this.encoding) {
            case NONE: {
                break;
            }
            case JWS: {
                this.validateJWSParameters();
                break;
            }
            case JWE: {
                this.validateJWEParameters();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported value for JWTEncoding : %s", new Object[]{this.encoding}));
            }
        }
    }

    private void validateJWEParameters() {
        if (this.secretKeyEncryption == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-106) JWE encoding requires a JWK secret for the encryption");
        }
    }

    private void validateJWSParameters() {
        if (this.secretKeySigning == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-105) JWS encoding requires a JWK secret for the signing");
        }
    }

    public static JWTParametersBuilder newBuilderFor(JWTEncoding encoding) {
        return new JWTParametersBuilder(encoding);
    }
}

