/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.keys;

import be.atbash.ee.security.octopus.jwt.keys.KeySelector;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.SecretJWK;
import java.security.Key;

public class SingleKeySelector
implements KeySelector {
    private JWK jwk;

    public SingleKeySelector(JWK jwk) {
        this.jwk = jwk;
    }

    @Override
    public <T extends Key> T selectSecretKey(String keyId) {
        try {
            if (keyId.equals(this.jwk.getKeyID())) {
                if (this.jwk instanceof SecretJWK) {
                    return (T)((SecretJWK)this.jwk).toSecretKey();
                }
                if (this.jwk instanceof AsymmetricJWK) {
                    return (T)((AsymmetricJWK)this.jwk).toPublicKey();
                }
                throw new UnsupportedOperationException("JWK not supported " + this.jwk.getClass().getName());
            }
        }
        catch (JOSEException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return null;
    }
}

