/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.keys;

import be.atbash.ee.security.octopus.jwk.JWKManager;
import be.atbash.ee.security.octopus.jwt.keys.KeySelector;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.SecretJWK;
import java.security.Key;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class JWKManagerKeySelector
implements KeySelector {
    @Inject
    private JWKManager jwkManager;

    @Override
    public <T extends Key> T selectSecretKey(String keyId) {
        if (this.jwkManager.existsApiKey(keyId)) {
            JWK jwk = this.jwkManager.getJWKForApiKey(keyId);
            try {
                if (jwk instanceof SecretJWK) {
                    return (T)((SecretJWK)jwk).toSecretKey();
                }
                if (jwk instanceof AsymmetricJWK) {
                    return (T)((AsymmetricJWK)jwk).toPublicKey();
                }
                throw new UnsupportedOperationException("JWK not supported " + jwk.getClass().getName());
            }
            catch (JOSEException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        return null;
    }
}

