/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.keys;

import be.atbash.util.StringUtils;
import be.atbash.util.base64.Base64Codec;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.SecretJWK;
import com.nimbusds.jose.util.ByteUtils;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HMACSecret
extends JWK
implements SecretJWK {
    private byte[] secret;

    public HMACSecret(byte[] secret, String id) {
        super(KeyType.OCT, KeyUse.SIGNATURE, null, new Algorithm("HMAC"), id, null, null, null, null, null);
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException("Parameter id should have a value");
        }
        this.secret = Objects.requireNonNull(secret, "Parameter secret should not be null");
    }

    public HMACSecret(String secret, String id, boolean base64Encode) {
        super(KeyType.OCT, KeyUse.SIGNATURE, null, new Algorithm("HMAC"), id, null, null, null, null, null);
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException("Parameter id should have a value");
        }
        if (!StringUtils.hasText((String)id)) {
            throw new IllegalArgumentException("Parameter secret should have a value");
        }
        this.secret = base64Encode ? Base64Codec.decode((String)secret) : secret.getBytes(Charset.forName("UTF-8"));
    }

    public LinkedHashMap<String, ?> getRequiredParams() {
        return new LinkedHashMap();
    }

    public boolean isPrivate() {
        return false;
    }

    public JWK toPublicJWK() {
        throw new UnsupportedOperationException("Method not implemented be.atbash.ee.security.octopus.jwt.keys.HMACSecret.toPublicJWK");
    }

    public int size() {
        return ByteUtils.bitLength((byte[])this.secret);
    }

    public SecretKey toSecretKey() {
        return new SecretKeySpec(this.secret, this.getAlgorithm().getName());
    }
}

