/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.encoder;

import be.atbash.ee.security.octopus.jwt.encoder.HMACAlgorithmFactory;
import be.atbash.ee.security.octopus.jwt.keys.HMACSecret;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersSigning;
import be.atbash.util.exception.AtbashIllegalActionException;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.RSAKey;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class JWTSignerFactory {
    @Inject
    private HMACAlgorithmFactory hmacAlgorithmFactory;

    public JWSSigner createSigner(JWTParametersSigning parametersSigning) {
        RSASSASigner result;
        switch (parametersSigning.getSecretKeyType()) {
            case HMAC: {
                try {
                    if (!(parametersSigning.getJWK() instanceof HMACSecret)) {
                        throw new AtbashIllegalActionException("(OCT-DEV-102) Secret is expected to be an instance of be.atbash.ee.security.octopus.jwt.keys.HMACSecret");
                    }
                    result = new MACSigner(((HMACSecret)parametersSigning.getJWK()).toSecretKey());
                    break;
                }
                catch (KeyLengthException e) {
                    throw new AtbashUnexpectedException((Throwable)e);
                }
            }
            case RSA: {
                if (!(parametersSigning.getJWK() instanceof RSAKey)) {
                    throw new AtbashIllegalActionException("(OCT-DEV-103) Secret is expected to be an instance of com.nimbusds.jose.jwk.RSAKey");
                }
                try {
                    result = new RSASSASigner((RSAKey)parametersSigning.getJWK());
                    break;
                }
                catch (JOSEException e) {
                    throw new AtbashUnexpectedException((Throwable)e);
                }
            }
            case EC: {
                if (!(parametersSigning.getJWK() instanceof ECKey)) {
                    throw new AtbashIllegalActionException("(OCT-DEV-104) Secret is expected to be an instance of com.nimbusds.jose.jwk.ECKey");
                }
                try {
                    result = new ECDSASigner((ECKey)parametersSigning.getJWK());
                    break;
                }
                catch (JOSEException e) {
                    throw new AtbashUnexpectedException((Throwable)e);
                }
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported value for SecretKeyType : %s", new Object[]{parametersSigning.getSecretKeyType()}));
            }
        }
        return result;
    }

    public JWSAlgorithm defineJWSAlgorithm(JWTParametersSigning parametersSigning) {
        JWSAlgorithm result;
        this.checkDependencies();
        switch (parametersSigning.getSecretKeyType()) {
            case HMAC: {
                result = this.hmacAlgorithmFactory.determineOptimalAlgorithm(((HMACSecret)parametersSigning.getJWK()).toSecretKey().getEncoded());
                break;
            }
            case RSA: {
                result = JWSAlgorithm.RS256;
                break;
            }
            case EC: {
                result = JWSAlgorithm.ES256;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported value for SecretKeyType : %s", new Object[]{parametersSigning.getSecretKeyType()}));
            }
        }
        return result;
    }

    private void checkDependencies() {
        if (this.hmacAlgorithmFactory == null) {
            this.hmacAlgorithmFactory = new HMACAlgorithmFactory();
        }
    }
}

