/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.encoder;

import be.atbash.config.exception.ConfigurationException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.util.ByteUtils;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class HMACAlgorithmFactory {
    public JWSAlgorithm determineOptimalAlgorithm(byte[] secret) {
        JWSAlgorithm result = null;
        Set algorithms = MACSigner.getCompatibleAlgorithms((int)ByteUtils.bitLength((byte[])secret));
        if (algorithms.contains(JWSAlgorithm.HS512)) {
            result = JWSAlgorithm.HS512;
        }
        if (result == null && algorithms.contains(JWSAlgorithm.HS384)) {
            result = JWSAlgorithm.HS384;
        }
        if (result == null && algorithms.contains(JWSAlgorithm.HS256)) {
            result = JWSAlgorithm.HS256;
        }
        if (result == null) {
            throw new ConfigurationException("Secret is too short for any JWS HMAC algorithm.");
        }
        return result;
    }
}

