/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.decoder;

import be.atbash.ee.security.octopus.jwt.InvalidJWTException;
import be.atbash.ee.security.octopus.jwt.JWTEncoding;
import be.atbash.ee.security.octopus.jwt.decoder.JWTData;
import be.atbash.ee.security.octopus.jwt.decoder.JWTVerifier;
import be.atbash.ee.security.octopus.jwt.decoder.MetaJWTData;
import be.atbash.ee.security.octopus.jwt.keys.KeySelector;
import be.atbash.json.JSONValue;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashIllegalActionException;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class JWTDecoder {
    private DefaultJWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();

    public <T> T decode(String data, Class<T> classType) {
        return this.decode(data, classType, null, null).getData();
    }

    public <T> JWTData<T> decode(String data, Class<T> classType, KeySelector keySelector, JWTVerifier verifier) {
        JWTData<T> result;
        JWTEncoding encoding = this.determineEncoding(data);
        if (encoding == null) {
            throw new IllegalArgumentException("Unable to determine the encoding of the data");
        }
        try {
            switch (encoding) {
                case NONE: {
                    result = this.readJSONString(data, classType);
                    break;
                }
                case JWS: {
                    if (keySelector == null) {
                        throw new AtbashIllegalActionException("(OCT-DEV-101) keySelector required for decoding a JWT encoded value");
                    }
                    result = this.readSignedJWT(data, keySelector, classType, verifier);
                    break;
                }
                case JWE: {
                    result = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("JWTEncoding not supported %s", new Object[]{encoding}));
                }
            }
        }
        catch (ParseException e) {
            throw new InvalidJWTException("Invalid JWT structure");
        }
        catch (JOSEException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }

    private <T> JWTData<T> readSignedJWT(String data, KeySelector keySelector, Class<T> classType, JWTVerifier verifier) throws ParseException, JOSEException {
        SignedJWT signedJWT = SignedJWT.parse((String)data);
        String keyID = signedJWT.getHeader().getKeyID();
        Object key = keySelector.selectSecretKey(keyID);
        if (key == null) {
            throw new InvalidJWTException(String.format("No key found for %s", keyID));
        }
        JWSVerifier jwsVerifier = this.jwsVerifierFactory.createJWSVerifier(signedJWT.getHeader(), key);
        if (!signedJWT.verify(jwsVerifier)) {
            throw new InvalidJWTException("JWT Signature verification failed");
        }
        if (verifier != null && !verifier.verify(signedJWT.getHeader(), signedJWT.getJWTClaimsSet())) {
            throw new InvalidJWTException("JWT verification failed");
        }
        MetaJWTData metaJWTData = new MetaJWTData(keyID, signedJWT.getHeader().getCustomParams());
        return this.readJSONString(signedJWT.getPayload().toString(), classType, metaJWTData);
    }

    private <T> JWTData<T> readJSONString(String data, Class<T> classType) {
        return this.readJSONString(data, classType, new MetaJWTData());
    }

    private <T> JWTData<T> readJSONString(String data, Class<T> classType, MetaJWTData metaJWTData) {
        return new JWTData<Object>(JSONValue.parse((String)data, classType), metaJWTData);
    }

    private JWTEncoding determineEncoding(String data) {
        JWTEncoding result = null;
        if (data.startsWith("{")) {
            result = JWTEncoding.NONE;
        }
        if (data.startsWith("ey")) {
            int occurrences = StringUtils.countOccurrences((String)data, (char)'.');
            if (occurrences == 2) {
                result = JWTEncoding.JWS;
            }
            if (occurrences == 4) {
                result = JWTEncoding.JWS;
            }
        }
        return result;
    }
}

