/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwk;

import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class RSAKeyFactory {
    public RSAKey makeRSA(Integer keySize, KeyUse keyUse, Algorithm keyAlg, String kid) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keySize);
            KeyPair kp = generator.generateKeyPair();
            RSAPublicKey pub = (RSAPublicKey)kp.getPublic();
            RSAPrivateKey priv = (RSAPrivateKey)kp.getPrivate();
            return new RSAKey.Builder(pub).privateKey(priv).keyUse(keyUse).algorithm(keyAlg).keyID(kid).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }
}

