/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwk;

import be.atbash.config.exception.ConfigurationException;
import be.atbash.ee.security.octopus.jwk.config.JwtSupportConfiguration;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Scanner;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class JWKManager {
    private JWKSet jwkSet;
    @Inject
    private JwtSupportConfiguration JwtSupportConfiguration;

    @PostConstruct
    public void init() {
        this.jwkSet = this.readJWKSet();
    }

    private JWKSet readJWKSet() {
        JWKSet result;
        String jwkFile = this.JwtSupportConfiguration.getJWKFile();
        if (!StringUtils.hasText((String)jwkFile)) {
            throw new ConfigurationException("A value for the parameter jwk.file is required");
        }
        InputStream inputStream = JWKManager.class.getClassLoader().getResourceAsStream(jwkFile);
        try {
            if (inputStream == null) {
                inputStream = new FileInputStream(jwkFile);
            }
            String content = new Scanner(inputStream).useDelimiter("\\Z").next();
            result = JWKSet.parse((String)content);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(String.format("JWK File not found at %s", jwkFile));
        }
        catch (ParseException e) {
            throw new ConfigurationException(String.format("Parsing the JWK file failed with %s", e.getMessage()));
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }

    public boolean existsApiKey(String apiKey) {
        return this.jwkSet.getKeyByKeyId(apiKey) != null;
    }

    public JWK getJWKForApiKey(String apiKey) {
        return this.jwkSet.getKeyByKeyId(apiKey);
    }

    public JWK getJWKSigningKey() {
        boolean multiple = false;
        JWK result = null;
        for (JWK jwk : this.jwkSet.getKeys()) {
            if (!jwk.isPrivate() || jwk.getKeyUse() != KeyUse.SIGNATURE) continue;
            if (result == null) {
                result = jwk;
                continue;
            }
            multiple = true;
        }
        if (multiple) {
            throw new ConfigurationException("FIXME Multiple signing keys");
        }
        if (result == null) {
            throw new ConfigurationException("FIXME No signing key found");
        }
        return result;
    }
}

