/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.writer;

import be.atbash.json.JSONAware;
import be.atbash.json.JSONUtil;
import be.atbash.json.JSONValue;
import be.atbash.json.style.JSONStyle;
import be.atbash.json.writer.ArrayWriter;
import be.atbash.json.writer.BeansWriter;
import be.atbash.json.writer.JSONWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JSONWriterFactory {
    private static final JSONWriterFactory WRITER_FACTORY = new JSONWriterFactory();
    private ConcurrentHashMap<Class<?>, JSONWriter<?>> writerCache = new ConcurrentHashMap();
    private LinkedList<WriterByInterface> writerInterfaces = new LinkedList();
    private JSONWriter<JSONAware> jsonAwareJSONWriter;
    private JSONWriter<Iterable<?>> jsonIterableWriter;
    private JSONWriter<Enum<?>> enumWriter;
    private JSONWriter<Map<String, ?>> jsonMapWriter;
    private JSONWriter<Object> beansWriter;
    private JSONWriter<Object> arrayWriter;
    private JSONWriter<Object> stringWriter;

    private JSONWriterFactory() {
        this.init();
    }

    public static JSONWriterFactory getInstance() {
        return WRITER_FACTORY;
    }

    public JSONWriter getWriterByInterface(Class<?> clazz) {
        for (WriterByInterface w : this.writerInterfaces) {
            if (!w._interface.isAssignableFrom(clazz)) continue;
            return w._writer;
        }
        return null;
    }

    public JSONWriter getWriter(Class cls) {
        return this.writerCache.get(cls);
    }

    public JSONWriter<Iterable<?>> getJsonIterableWriter() {
        return this.jsonIterableWriter;
    }

    public JSONWriter<Map<String, ?>> getJsonMapWriter() {
        return this.jsonMapWriter;
    }

    public JSONWriter<Object> getBeansWriter() {
        return this.beansWriter;
    }

    public JSONWriter<Object> getArrayWriter() {
        return this.arrayWriter;
    }

    private void init() {
        this.createWriters();
        this.registerWriter(new JSONWriter<String>(){

            @Override
            public void writeJSONString(String value, Appendable out) throws IOException {
                JSONStyle.getDefault().writeString(out, value);
            }
        }, String.class);
        this.registerWriter(new JSONWriter<Double>(){

            @Override
            public void writeJSONString(Double value, Appendable out) throws IOException {
                if (value.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            }
        }, Double.class);
        this.registerWriter(new JSONWriter<Date>(){

            @Override
            public void writeJSONString(Date value, Appendable out) throws IOException {
                out.append('\"');
                JSONStyle.getDefault().escape(value.toString(), out);
                out.append('\"');
            }
        }, Date.class);
        this.registerWriter(new JSONWriter<Float>(){

            @Override
            public void writeJSONString(Float value, Appendable out) throws IOException {
                if (value.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            }
        }, Float.class);
        this.registerWriter(this.stringWriter, Integer.class, Long.class, Byte.class, Short.class, BigInteger.class, BigDecimal.class);
        this.registerWriter(this.stringWriter, Boolean.class);
        this.registerWriter(new JSONWriter<int[]>(){

            @Override
            public void writeJSONString(int[] value, Appendable out) throws IOException {
                boolean needSep = false;
                JSONStyle.getDefault().arrayStart(out);
                for (int b : value) {
                    if (needSep) {
                        JSONStyle.getDefault().objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Integer.toString(b));
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        }, int[].class);
        this.registerWriter(new JSONWriter<short[]>(){

            @Override
            public void writeJSONString(short[] value, Appendable out) throws IOException {
                boolean needSep = false;
                JSONStyle.getDefault().arrayStart(out);
                for (short b : value) {
                    if (needSep) {
                        JSONStyle.getDefault().objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Short.toString(b));
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        }, short[].class);
        this.registerWriter(new JSONWriter<long[]>(){

            @Override
            public void writeJSONString(long[] value, Appendable out) throws IOException {
                boolean needSep = false;
                JSONStyle.getDefault().arrayStart(out);
                for (long b : value) {
                    if (needSep) {
                        JSONStyle.getDefault().objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Long.toString(b));
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        }, long[].class);
        this.registerWriter(new JSONWriter<float[]>(){

            @Override
            public void writeJSONString(float[] value, Appendable out) throws IOException {
                boolean needSep = false;
                JSONStyle.getDefault().arrayStart(out);
                for (float b : value) {
                    if (needSep) {
                        JSONStyle.getDefault().objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Float.toString(b));
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        }, float[].class);
        this.registerWriter(new JSONWriter<double[]>(){

            @Override
            public void writeJSONString(double[] value, Appendable out) throws IOException {
                boolean needSep = false;
                JSONStyle.getDefault().arrayStart(out);
                for (double b : value) {
                    if (needSep) {
                        JSONStyle.getDefault().objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Double.toString(b));
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        }, double[].class);
        this.registerWriter(new JSONWriter<boolean[]>(){

            @Override
            public void writeJSONString(boolean[] value, Appendable out) throws IOException {
                boolean needSep = false;
                JSONStyle.getDefault().arrayStart(out);
                for (boolean b : value) {
                    if (needSep) {
                        JSONStyle.getDefault().objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Boolean.toString(b));
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        }, boolean[].class);
        this.registerWriterInterface(JSONAware.class, this.jsonAwareJSONWriter);
        this.registerWriterInterface(Map.class, this.jsonMapWriter);
        this.registerWriterInterface(Iterable.class, this.jsonIterableWriter);
        this.registerWriterInterface(Enum.class, this.enumWriter);
        this.registerWriterInterface(Number.class, this.stringWriter);
    }

    private void createWriters() {
        this.stringWriter = new JSONWriter<Object>(){

            @Override
            public void writeJSONString(Object value, Appendable out) throws IOException {
                out.append(value.toString());
            }
        };
        this.beansWriter = new BeansWriter();
        this.arrayWriter = new ArrayWriter();
        this.enumWriter = new JSONWriter<Enum<?>>(){

            @Override
            public <E extends Enum<?>> void writeJSONString(E value, Appendable out) throws IOException {
                String s = value.name();
                JSONStyle.getDefault().writeString(out, s);
            }
        };
        this.jsonAwareJSONWriter = new JSONWriter<JSONAware>(){

            @Override
            public <E extends JSONAware> void writeJSONString(E value, Appendable out) throws IOException {
                out.append(value.toJSONString());
            }
        };
        this.jsonMapWriter = new JSONWriter<Map<String, ?>>(){

            @Override
            public <E extends Map<String, ?>> void writeJSONString(E map, Appendable out) throws IOException {
                boolean first = true;
                JSONStyle.getDefault().objectStart(out);
                for (Map.Entry<String, ?> entry : map.entrySet()) {
                    Object v = entry.getValue();
                    if (v == null && JSONStyle.getDefault().ignoreNull()) continue;
                    if (first) {
                        JSONStyle.getDefault().objectFirstStart(out);
                        first = false;
                    } else {
                        JSONStyle.getDefault().objectNext(out);
                    }
                    JSONUtil.writeJSONKV(entry.getKey().toString(), v, out);
                }
                JSONStyle.getDefault().objectStop(out);
            }
        };
        this.jsonIterableWriter = new JSONWriter<Iterable<?>>(){

            @Override
            public <E extends Iterable<?>> void writeJSONString(E list, Appendable out) throws IOException {
                boolean first = true;
                JSONStyle.getDefault().arrayStart(out);
                for (Object value : list) {
                    if (first) {
                        first = false;
                        JSONStyle.getDefault().arrayFirstObject(out);
                    } else {
                        JSONStyle.getDefault().arrayNextElement(out);
                    }
                    if (value == null) {
                        out.append("null");
                    } else {
                        JSONValue.writeJSONString(value, out);
                    }
                    JSONStyle.getDefault().arrayObjectEnd(out);
                }
                JSONStyle.getDefault().arrayStop(out);
            }
        };
    }

    public void registerWriterInterfaceLast(Class<?> interFace, JSONWriter<?> writer) {
        this.writerInterfaces.addLast(new WriterByInterface(interFace, writer));
    }

    public void registerWriterInterfaceFirst(Class<?> interFace, JSONWriter<?> writer) {
        this.writerInterfaces.addFirst(new WriterByInterface(interFace, writer));
    }

    public void registerWriterInterface(Class<?> interFace, JSONWriter<?> writer) {
        this.registerWriterInterfaceLast(interFace, writer);
    }

    public <T> void registerWriter(JSONWriter<T> writer, Class<?> ... cls) {
        for (Class<?> c : cls) {
            this.writerCache.put(c, writer);
        }
    }

    static class WriterByInterface {
        private Class<?> _interface;
        private JSONWriter<?> _writer;

        WriterByInterface(Class<?> _interface, JSONWriter<?> _writer) {
            this._interface = _interface;
            this._writer = _writer;
        }
    }
}

