/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.parser.reader;

import be.atbash.json.JSONArray;
import be.atbash.json.JSONObject;
import be.atbash.json.JSONUtil;
import be.atbash.json.asm.BeansAccess;
import be.atbash.json.asm.FieldFilter;
import be.atbash.json.parser.reader.DefaultJSONEncoder;
import be.atbash.json.parser.reader.JSONEncoder;
import be.atbash.json.parser.reader.JSONEncoderFactory;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public final class CollectionEncoder {
    private CollectionEncoder() {
    }

    public static class ListClass<T>
    extends JSONEncoder<T> {
        final Class<?> type;
        final Class<?> instance;
        final BeansAccess<?> beansAccess;

        ListClass(Class<?> clazz) {
            this.type = clazz;
            this.instance = clazz.isInterface() ? JSONArray.class : clazz;
            this.beansAccess = BeansAccess.get(this.instance, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
        }

        @Override
        public Object createArray() {
            return this.beansAccess.newInstance();
        }

        @Override
        public JSONEncoder<?> startArray(String key) {
            return DefaultJSONEncoder.getInstance();
        }

        @Override
        public JSONEncoder<?> startObject(String key) {
            return DefaultJSONEncoder.getInstance();
        }

        @Override
        public void addValue(Object current, Object value) {
            ((List)current).add(value);
        }
    }

    public static class ListType<T>
    extends JSONEncoder<T> {
        private final ParameterizedType type;
        private final Class<?> rawClass;
        private final Class<?> instance;
        private final BeansAccess<?> beansAccess;
        private final Type valueType;
        private final Class<?> valueClass;
        private JSONEncoder<?> subJSONEncoder;

        ListType(ParameterizedType type) {
            this.type = type;
            this.rawClass = (Class)type.getRawType();
            this.instance = this.rawClass.isInterface() ? JSONArray.class : this.rawClass;
            this.beansAccess = BeansAccess.get(this.instance, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
            this.valueType = type.getActualTypeArguments()[0];
            this.valueClass = this.valueType instanceof Class ? (Class)this.valueType : (Class)((ParameterizedType)this.valueType).getRawType();
        }

        @Override
        public Object createArray() {
            return this.beansAccess.newInstance();
        }

        @Override
        public JSONEncoder<?> startArray(String key) {
            if (this.subJSONEncoder == null) {
                this.subJSONEncoder = JSONEncoderFactory.getInstance().getEncoder(this.type.getActualTypeArguments()[0]);
            }
            return this.subJSONEncoder;
        }

        @Override
        public JSONEncoder<?> startObject(String key) {
            if (this.subJSONEncoder == null) {
                this.subJSONEncoder = JSONEncoderFactory.getInstance().getEncoder(this.type.getActualTypeArguments()[0]);
            }
            return this.subJSONEncoder;
        }

        @Override
        public void addValue(Object current, Object value) {
            ((List)current).add(JSONUtil.convertToX(value, this.valueClass));
        }
    }

    public static class MapClass<T>
    extends JSONEncoder<T> {
        private final Class<?> type;
        private final Class<?> instance;
        private final BeansAccess<?> beansAccess;

        MapClass(Class<?> type) {
            this.type = type;
            this.instance = type.isInterface() ? JSONObject.class : type;
            this.beansAccess = BeansAccess.get(this.instance, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
        }

        @Override
        public T createObject() {
            return (T)this.beansAccess.newInstance();
        }

        @Override
        public JSONEncoder<?> startArray(String key) {
            return DefaultJSONEncoder.getInstance();
        }

        @Override
        public JSONEncoder<?> startObject(String key) {
            return DefaultJSONEncoder.getInstance();
        }

        @Override
        public void setValue(Object current, String key, Object value) {
            ((Map)current).put(key, value);
        }

        @Override
        public Object getValue(Object current, String key) {
            return ((Map)current).get(key);
        }

        @Override
        public Type getType(String key) {
            return this.type;
        }
    }

    public static class MapType<T>
    extends JSONEncoder<T> {
        private final ParameterizedType type;
        private final Class<?> rawClass;
        private final Class<?> instance;
        private final Type keyType;
        private final Type valueType;
        private final Class<?> keyClass;
        private final Class<?> valueClass;
        private JSONEncoder<?> subJSONEncoder;

        MapType(ParameterizedType type) {
            this.type = type;
            this.rawClass = (Class)type.getRawType();
            this.instance = this.rawClass.isInterface() ? JSONObject.class : this.rawClass;
            this.keyType = type.getActualTypeArguments()[0];
            this.valueType = type.getActualTypeArguments()[1];
            this.keyClass = this.keyType instanceof Class ? (Class)this.keyType : (Class)((ParameterizedType)this.keyType).getRawType();
            this.valueClass = this.valueType instanceof Class ? (Class)this.valueType : (Class)((ParameterizedType)this.valueType).getRawType();
        }

        @Override
        public T createObject() {
            try {
                return (T)this.instance.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }

        @Override
        public JSONEncoder<?> startArray(String key) {
            if (this.subJSONEncoder == null) {
                this.subJSONEncoder = JSONEncoderFactory.getInstance().getEncoder(this.valueType);
            }
            return this.subJSONEncoder;
        }

        @Override
        public JSONEncoder<?> startObject(String key) {
            if (this.subJSONEncoder == null) {
                this.subJSONEncoder = JSONEncoderFactory.getInstance().getEncoder(this.valueType);
            }
            return this.subJSONEncoder;
        }

        @Override
        public void setValue(Object current, String key, Object value) {
            ((Map)current).put(JSONUtil.convertToX(key, this.keyClass), JSONUtil.convertToX(value, this.valueClass));
        }

        @Override
        public Object getValue(Object current, String key) {
            return ((Map)current).get(JSONUtil.convertToX(key, this.keyClass));
        }

        @Override
        public Type getType(String key) {
            return this.type;
        }
    }
}

