/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.parser;

import be.atbash.json.parser.ParseException;
import be.atbash.json.parser.reader.DefaultJSONEncoder;
import be.atbash.json.parser.reader.JSONEncoder;
import be.atbash.json.parser.reader.JSONEncoderBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;

class JSONParserString {
    private static final byte EOI = 26;
    private static final char MAX_STOP = '~';
    private static boolean[] stopAll = new boolean[126];
    private static boolean[] stopArray = new boolean[126];
    private static boolean[] stopKey = new boolean[126];
    private static boolean[] stopValue = new boolean[126];
    private static boolean[] stopX = new boolean[126];
    private final boolean acceptLeadinZero;
    private final boolean acceptNaN;
    private final boolean acceptNonQuote;
    private final boolean acceptSimpleQuote;
    private final boolean acceptUselessComma;
    private final boolean checkTailingData;
    private final boolean checkTailingSpace;
    private final boolean ignoreControlChar;
    private final boolean useHiPrecisionFloat;
    private final boolean useIntegerStorage;
    private final boolean reject127;
    private String json;
    private int len;
    private char c;
    private String lastKey;
    private final MSB sb = new MSB(15);
    private Object xo;
    private String xs;
    private int pos;

    JSONParserString(int permissiveMode) {
        this.acceptNaN = (permissiveMode & 4) > 0;
        this.acceptNonQuote = (permissiveMode & 2) > 0;
        this.acceptSimpleQuote = (permissiveMode & 1) > 0;
        this.ignoreControlChar = (permissiveMode & 8) > 0;
        this.useIntegerStorage = (permissiveMode & 0x10) > 0;
        this.acceptLeadinZero = (permissiveMode & 0x20) > 0;
        this.acceptUselessComma = (permissiveMode & 0x40) > 0;
        this.useHiPrecisionFloat = (permissiveMode & 0x80) > 0;
        this.checkTailingData = (permissiveMode & 0x300) != 768;
        this.checkTailingSpace = (permissiveMode & 0x200) == 0;
        this.reject127 = (permissiveMode & 0x400) > 0;
    }

    public Object parse(String json) {
        return this.parse(json, DefaultJSONEncoder.getInstance());
    }

    public <T> T parse(String json, JSONEncoder<T> jsonEncoder) {
        if (json == null) {
            throw new IllegalArgumentException("Parameter JSON text cannot be null");
        }
        this.json = json;
        this.len = json.length();
        return this.parse(jsonEncoder);
    }

    private <T> T parse(JSONEncoder<T> jsonEncoder) {
        this.pos = -1;
        this.read();
        T result = this.readFirst(jsonEncoder);
        if (this.checkTailingData) {
            if (!this.checkTailingSpace) {
                this.skipSpace();
            }
            if (this.c != '\u001a') {
                throw new ParseException(this.pos - 1, 1, Character.valueOf(this.c));
            }
        }
        this.xs = null;
        this.xo = null;
        return result;
    }

    private void checkControlChar() {
        if (this.ignoreControlChar) {
            return;
        }
        int l = this.xs.length();
        for (int i = 0; i < l; ++i) {
            char c = this.xs.charAt(i);
            if (c <= '\u001f') {
                throw new ParseException(this.pos + i, 0, Character.valueOf(c));
            }
            if (c != '\u007f' || !this.reject127) continue;
            throw new ParseException(this.pos + i, 0, Character.valueOf(c));
        }
    }

    private void checkLeadingZero() {
        int len = this.xs.length();
        if (len == 1) {
            return;
        }
        if (len == 2) {
            if ("00".equals(this.xs)) {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        char c1 = this.xs.charAt(0);
        char c2 = this.xs.charAt(1);
        if (c1 == '-') {
            char c3 = this.xs.charAt(2);
            if (c2 == '0' && c3 >= '0' && c3 <= '9') {
                throw new ParseException(this.pos, 6, this.xs);
            }
            return;
        }
        if (c1 == '0' && c2 >= '0' && c2 <= '9') {
            throw new ParseException(this.pos, 6, this.xs);
        }
    }

    private Number extractFloat() {
        if (!this.acceptLeadinZero) {
            this.checkLeadingZero();
        }
        if (!this.useHiPrecisionFloat) {
            return Float.valueOf(Float.parseFloat(this.xs));
        }
        if (this.xs.length() > 18) {
            return new BigDecimal(this.xs);
        }
        return Double.parseDouble(this.xs);
    }

    private Number parseNumber(String s) {
        boolean mustCheck;
        boolean neg;
        int p = 0;
        int l = s.length();
        int max = 19;
        if (s.charAt(0) == '-') {
            ++p;
            ++max;
            neg = true;
            if (!this.acceptLeadinZero && l >= 3 && s.charAt(1) == '0') {
                throw new ParseException(this.pos, 6, s);
            }
        } else {
            neg = false;
            if (!this.acceptLeadinZero && l >= 2 && s.charAt(0) == '0') {
                throw new ParseException(this.pos, 6, s);
            }
        }
        if (l < max) {
            max = l;
            mustCheck = false;
        } else {
            if (l > max) {
                return new BigInteger(s, 10);
            }
            max = l - 1;
            mustCheck = true;
        }
        long r = 0L;
        while (p < max) {
            r = r * 10L + (long)(48 - s.charAt(p++));
        }
        if (mustCheck) {
            boolean isBig;
            if (r > -922337203685477580L) {
                isBig = false;
            } else if (r < -922337203685477580L) {
                isBig = true;
            } else if (neg) {
                isBig = s.charAt(p) > '8';
            } else {
                boolean bl = isBig = s.charAt(p) > '7';
            }
            if (isBig) {
                return new BigInteger(s, 10);
            }
            r = r * 10L + (long)(48 - s.charAt(p));
        }
        if (neg) {
            if (this.useIntegerStorage && r >= Integer.MIN_VALUE) {
                return (int)r;
            }
            return r;
        }
        r = -r;
        if (this.useIntegerStorage && r <= Integer.MAX_VALUE) {
            return (int)r;
        }
        return r;
    }

    private <T> T readArray(JSONEncoder<T> jsonEncoder) {
        Object current = jsonEncoder.createArray();
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        boolean needData = false;
        if (this.c == ',' && !this.acceptUselessComma) {
            throw new ParseException(this.pos, 0, Character.valueOf(this.c));
        }
        block7: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block7;
                }
                case ']': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    return jsonEncoder.convert(current);
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case ',': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    needData = true;
                    continue block7;
                }
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            jsonEncoder.addValue(current, this.readMain(jsonEncoder, stopArray));
            needData = false;
        }
    }

    private <T> T readFirst(JSONEncoder<T> jsonEncoder) {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject(jsonEncoder);
                }
                case '[': {
                    return this.readArray(jsonEncoder);
                }
                case '\"': 
                case '\'': {
                    this.readString();
                    return jsonEncoder.convert(this.xs);
                }
                case 'n': {
                    this.readNQString(stopX);
                    if ("null".equals(this.xs)) {
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonEncoder.convert(this.xs);
                }
                case 'f': {
                    this.readNQString(stopX);
                    if ("false".equals(this.xs)) {
                        return jsonEncoder.convert(Boolean.FALSE);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonEncoder.convert(this.xs);
                }
                case 't': {
                    this.readNQString(stopX);
                    if ("true".equals(this.xs)) {
                        return jsonEncoder.convert(Boolean.TRUE);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonEncoder.convert(this.xs);
                }
                case 'N': {
                    this.readNQString(stopX);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        return jsonEncoder.convert(Float.valueOf(Float.NaN));
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return jsonEncoder.convert(this.xs);
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.xo = this.readNumber(stopX);
                    return jsonEncoder.convert(this.xo);
                }
            }
            break;
        }
        this.readNQString(stopX);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        return jsonEncoder.convert(this.xs);
    }

    private Object readMain(JSONEncoder<?> jsonEncoder, boolean[] stop) {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '{': {
                    return this.readObject(jsonEncoder.startObject(this.lastKey));
                }
                case '[': {
                    return this.readArray(jsonEncoder.startArray(this.lastKey));
                }
                case '\"': 
                case '\'': {
                    this.readString();
                    return this.xs;
                }
                case 'n': {
                    this.readNQString(stop);
                    if ("null".equals(this.xs)) {
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case 'f': {
                    this.readNQString(stop);
                    if ("false".equals(this.xs)) {
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case 't': {
                    this.readNQString(stop);
                    if ("true".equals(this.xs)) {
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case 'N': {
                    this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    return this.xs;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber(stop);
                }
            }
            break;
        }
        this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        return this.xs;
    }

    private <T, U> T readObject(JSONEncoder<T> jsonEncoder) {
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        T current = jsonEncoder.createObject();
        Object builder = null;
        if (jsonEncoder instanceof JSONEncoderBuilder) {
            builder = ((JSONEncoderBuilder)((Object)jsonEncoder)).createBuilder();
        }
        boolean needData = false;
        boolean acceptData = true;
        block6: while (true) {
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case '[': 
                case ']': 
                case '{': {
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '}': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    this.read();
                    return jsonEncoder.convert(current);
                }
                case ',': {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                    }
                    needData = true;
                    acceptData = true;
                    continue block6;
                }
            }
            if (this.c == '\"' || this.c == '\'') {
                this.readString();
            } else {
                this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
            }
            String key = this.xs;
            if (!acceptData) {
                throw new ParseException(this.pos, 1, key);
            }
            this.skipSpace();
            if (this.c != ':') {
                if (this.c == '\u001a') {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                throw new ParseException(this.pos - 1, 0, Character.valueOf(this.c));
            }
            this.readNoEnd();
            this.lastKey = key;
            Object value = this.readMain(jsonEncoder, stopValue);
            if (builder == null) {
                jsonEncoder.setValue(current, key, value);
            } else {
                ((JSONEncoderBuilder)((Object)jsonEncoder)).setBuilderValue(builder, key, value);
            }
            this.lastKey = null;
            this.skipSpace();
            if (this.c == '}') {
                this.read();
                if (builder == null) {
                    return jsonEncoder.convert(current);
                }
                return ((JSONEncoderBuilder)((Object)jsonEncoder)).build(builder);
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos - 1, 3, null);
            }
            if (this.c != ',') break;
            needData = true;
            acceptData = true;
        }
        throw new ParseException(this.pos - 1, 1, Character.valueOf(this.c));
    }

    private void readString2() {
        char sep = this.c;
        block20: while (true) {
            this.read();
            switch (this.c) {
                case '\u001a': {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case '\"': 
                case '\'': {
                    if (sep == this.c) {
                        this.read();
                        this.xs = this.sb.toString();
                        return;
                    }
                    this.sb.append(this.c);
                    continue block20;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            continue block20;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            continue block20;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            continue block20;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            continue block20;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            continue block20;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            continue block20;
                        }
                        case '/': {
                            this.sb.append('/');
                            continue block20;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            continue block20;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            continue block20;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode(4));
                            continue block20;
                        }
                        case 'x': {
                            this.sb.append(this.readUnicode(2));
                            continue block20;
                        }
                    }
                    continue block20;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    if (this.ignoreControlChar) continue block20;
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
                case '\u007f': {
                    if (this.ignoreControlChar) continue block20;
                    if (!this.reject127) break;
                    throw new ParseException(this.pos, 0, Character.valueOf(this.c));
                }
            }
            this.sb.append(this.c);
        }
    }

    private char readUnicode(int totalChars) {
        int value = 0;
        for (int i = 0; i < totalChars; ++i) {
            value *= 16;
            this.read();
            if (this.c <= '9' && this.c >= '0') {
                value += this.c - 48;
                continue;
            }
            if (this.c <= 'F' && this.c >= 'A') {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                value += this.c - 97 + 10;
                continue;
            }
            if (this.c == '\u001a') {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, Character.valueOf(this.c));
        }
        return (char)value;
    }

    private void skipDigits() {
        while (this.c >= '0' && this.c <= '9') {
            this.read();
        }
    }

    private void skipNQString(boolean[] stop) {
        while (!(this.c == '\u001a' || this.c < '~' && stop[this.c])) {
            this.read();
        }
    }

    private void skipSpace() {
        while (this.c <= ' ' && this.c != '\u001a') {
            this.read();
        }
    }

    private void readNQString(boolean[] stop) {
        int start = this.pos;
        this.skipNQString(stop);
        this.extractStringTrim(start, this.pos);
    }

    private Object readNumber(boolean[] stop) {
        int start = this.pos;
        this.read();
        this.skipDigits();
        if (this.c != '.' && this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (this.c < '~' && !stop[this.c] && this.c != '\u001a') {
                this.skipNQString(stop);
                this.extractStringTrim(start, this.pos);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.extractStringTrim(start, this.pos);
            return this.parseNumber(this.xs);
        }
        if (this.c == '.') {
            this.read();
            this.skipDigits();
        }
        if (this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (this.c < '~' && !stop[this.c] && this.c != '\u001a') {
                this.skipNQString(stop);
                this.extractStringTrim(start, this.pos);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.extractStringTrim(start, this.pos);
            return this.extractFloat();
        }
        this.sb.append('E');
        this.read();
        if (this.c == '+' || this.c == '-' || this.c >= '0' && this.c <= '9') {
            this.sb.append(this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (this.c < '~' && !stop[this.c] && this.c != '\u001a') {
                this.skipNQString(stop);
                this.extractStringTrim(start, this.pos);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.extractStringTrim(start, this.pos);
            return this.extractFloat();
        }
        this.skipNQString(stop);
        this.extractStringTrim(start, this.pos);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        if (!this.acceptLeadinZero) {
            this.checkLeadingZero();
        }
        return this.xs;
    }

    private void readString() {
        if (!this.acceptSimpleQuote && this.c == '\'') {
            if (this.acceptNonQuote) {
                this.readNQString(stopAll);
                return;
            }
            throw new ParseException(this.pos, 0, Character.valueOf(this.c));
        }
        int tmpP = this.json.indexOf(this.c, this.pos + 1);
        if (tmpP == -1) {
            throw new ParseException(this.len, 3, null);
        }
        this.extractString(this.pos + 1, tmpP);
        if (this.xs.indexOf(92) == -1) {
            this.checkControlChar();
            this.pos = tmpP;
            this.read();
            return;
        }
        this.sb.clear();
        this.readString2();
    }

    private void extractString(int beginIndex, int endIndex) {
        this.xs = this.json.substring(beginIndex, endIndex);
    }

    private void extractStringTrim(int start, int stop) {
        while (start < stop - 1 && Character.isWhitespace(this.json.charAt(start))) {
            ++start;
        }
        while (stop - 1 > start && Character.isWhitespace(this.json.charAt(stop - 1))) {
            --stop;
        }
        this.extractString(start, stop);
    }

    private void read() {
        this.c = ++this.pos >= this.len ? (char)26 : this.json.charAt(this.pos);
    }

    private void readNoEnd() {
        if (++this.pos >= this.len) {
            this.c = (char)26;
            throw new ParseException(this.pos - 1, 3, "EOF");
        }
        this.c = this.json.charAt(this.pos);
    }

    static {
        JSONParserString.stopKey[26] = true;
        JSONParserString.stopKey[58] = true;
        JSONParserString.stopValue[26] = true;
        JSONParserString.stopValue[125] = true;
        JSONParserString.stopValue[44] = true;
        JSONParserString.stopArray[26] = true;
        JSONParserString.stopArray[93] = true;
        JSONParserString.stopArray[44] = true;
        JSONParserString.stopX[26] = true;
        JSONParserString.stopAll[58] = true;
        JSONParserString.stopAll[44] = true;
        JSONParserString.stopAll[26] = true;
        JSONParserString.stopAll[125] = true;
        JSONParserString.stopAll[93] = true;
    }

    private static class MSB {
        char[] b;
        int p;

        MSB(int size) {
            this.b = new char[size];
            this.p = -1;
        }

        void append(char c) {
            ++this.p;
            if (this.b.length <= this.p) {
                char[] t = new char[this.b.length * 2 + 1];
                System.arraycopy(this.b, 0, t, 0, this.b.length);
                this.b = t;
            }
            this.b[this.p] = c;
        }

        public String toString() {
            return new String(this.b, 0, this.p + 1);
        }

        void clear() {
            this.p = -1;
        }
    }
}

