/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.parser;

import be.atbash.json.parser.JSONParserString;
import be.atbash.json.parser.reader.JSONEncoder;
import be.atbash.json.parser.reader.JSONEncoderFactory;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int ACCEPT_TAILLING_SPACE = 512;
    public static final int REJECT_127_CHAR = 1024;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 656;
    public static final int MODE_JSON_SIMPLE = 1984;
    public static final int MODE_STRICTEST = 1168;
    public static final int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 1984 : -1;
    private int mode;
    private JSONParserString stringParser;

    public JSONParser() {
        this(DEFAULT_PERMISSIVE_MODE);
    }

    public JSONParser(int permissifMode) {
        this.mode = permissifMode;
    }

    private JSONParserString getStringParser() {
        if (this.stringParser == null) {
            this.stringParser = new JSONParserString(this.mode);
        }
        return this.stringParser;
    }

    public Object parse(String json) {
        return this.getStringParser().parse(json);
    }

    public <T> T parse(String in, JSONEncoder<T> jsonEncoder) {
        return this.getStringParser().parse(in, jsonEncoder);
    }

    public <T> T parse(String in, Class<T> mapTo) {
        return this.getStringParser().parse(in, JSONEncoderFactory.getInstance().getEncoder(mapTo));
    }
}

