/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json;

import be.atbash.json.JSONAware;
import be.atbash.json.writer.JSONWriterFactory;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JSONArray
extends ArrayList<Object>
implements JSONAware {
    public static String toJSONString(List<?> list) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONArray.writeJSONString(list, sb);
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return sb.toString();
    }

    private static void writeJSONString(Iterable<?> list, Appendable out) throws IOException {
        if (list == null) {
            out.append("null");
            return;
        }
        JSONWriterFactory.getInstance().getJsonIterableWriter().writeJSONString(list, out);
    }

    public JSONArray appendElement(Object element) {
        this.add(element);
        return this;
    }

    public void merge(Object object) {
        JSONArray.merge(this, object);
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONWriterFactory.getInstance().getJsonIterableWriter().writeJSONString(this, sb);
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public static JSONArray merge(JSONArray array1, Object array2) {
        if (array2 == null) {
            return array1;
        }
        if (array2 instanceof JSONArray) {
            return JSONArray.merge(array1, (JSONArray)array2);
        }
        array1.add(array2);
        return array1;
    }

    public static JSONArray merge(JSONArray array1, JSONArray array2) {
        array1.addAll(array2);
        return array1;
    }
}

