/*
 * Copyright 2017-2018 Rudy De Busscher (https://www.atbash.be)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package be.atbash.json.parser;

import be.atbash.json.writer.CustomBeanJSONEncoder;
import be.atbash.json.writer.JSONWriter;
import be.atbash.util.PublicAPI;

import java.lang.annotation.*;

/**
 * Atbash added file
 */
@Documented
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@PublicAPI
public @interface MappedBy {

    Class<? extends CustomJSONEncoder> encoder() default CustomJSONEncoder.NOPJSONEncoder.class;

    Class<? extends CustomBeanJSONEncoder> beanEncoder() default CustomBeanJSONEncoder.NOPCustomBeanJSONEncoder.class;

    Class<? extends JSONWriter> writer() default JSONWriter.NOPJSONWriter.class;
}
