/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.writer;

import be.atbash.json.JSONUtil;
import be.atbash.json.style.JSONStyle;
import be.atbash.json.writer.JSONWriter;
import java.io.IOException;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.FieldFilter;

public class BeansWriter
implements JSONWriter<Object> {
    @Override
    public <E> void writeJSONString(E value, Appendable out) throws IOException {
        Class<?> cls = value.getClass();
        boolean needSep = false;
        BeansAccess fields = BeansAccess.get(cls, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
        JSONStyle.getDefault().objectStart(out);
        for (Accessor field : fields.getAccessors()) {
            Object v = fields.get(value, field.getIndex());
            if (v == null && JSONStyle.getDefault().ignoreNull()) continue;
            if (needSep) {
                JSONStyle.getDefault().objectNext(out);
            } else {
                needSep = true;
            }
            String key = field.getName();
            JSONUtil.writeJSONKV(key, v, out);
        }
        JSONStyle.getDefault().objectStop(out);
    }
}

