/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.style;

import be.atbash.json.style.JStylerObj;
import java.io.IOException;

public class JSONStyle {
    private static final JSONStyle DEFAULT = new JSONStyle();
    private boolean _ignore_null = true;
    private JStylerObj.StringProtector esc = JStylerObj.ESCAPE4Web;

    private JSONStyle() {
    }

    public boolean ignoreNull() {
        return this._ignore_null;
    }

    public void writeString(Appendable out, String value) throws IOException {
        out.append('\"');
        this.escape(value, out);
        out.append('\"');
    }

    public void escape(String s, Appendable out) {
        if (s == null) {
            return;
        }
        this.esc.escape(s, out);
    }

    public void objectStart(Appendable out) throws IOException {
        out.append('{');
    }

    public void objectStop(Appendable out) throws IOException {
        out.append('}');
    }

    public void objectFirstStart(Appendable out) {
    }

    public void objectNext(Appendable out) throws IOException {
        out.append(',');
    }

    public void objectElmStop(Appendable out) {
    }

    public void objectEndOfKey(Appendable out) throws IOException {
        out.append(':');
    }

    public void arrayStart(Appendable out) throws IOException {
        out.append('[');
    }

    public void arrayStop(Appendable out) throws IOException {
        out.append(']');
    }

    public void arrayFirstObject(Appendable out) {
    }

    public void arrayNextElement(Appendable out) throws IOException {
        out.append(',');
    }

    public void arrayObjectEnd(Appendable out) {
    }

    public static JSONStyle getDefault() {
        return DEFAULT;
    }
}

