/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.parser.reader;

import be.atbash.json.parser.CustomJSONEncoder;
import be.atbash.json.parser.MappedBy;
import be.atbash.json.parser.reader.ArraysJSONEncoder;
import be.atbash.json.parser.reader.BeanEncoder;
import be.atbash.json.parser.reader.CollectionEncoder;
import be.atbash.json.parser.reader.JSONEncoder;
import be.atbash.json.parser.reader.JSONEncoderWrappedCustomEncoder;
import be.atbash.json.writer.CustomBeanJSONEncoder;
import be.atbash.util.exception.AtbashException;
import be.atbash.util.reflection.ClassUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JSONEncoderFactory {
    private static final Object LOCK = new Object();
    private static JSONEncoderFactory INSTANCE;
    private ConcurrentHashMap<Type, JSONEncoder<?>> cache;

    private JSONEncoderFactory() {
    }

    private void initEncoders() {
        this.cache = new ConcurrentHashMap(20);
        this.cache.put((Type)((Object)Date.class), BeanEncoder.getJsonEncoderDate());
        this.cache.put((Type)((Object)int[].class), ArraysJSONEncoder.getJSONEncoderPrimInt());
        this.cache.put((Type)((Object)Integer[].class), ArraysJSONEncoder.getJSONEncoderInt());
        this.cache.put((Type)((Object)short[].class), ArraysJSONEncoder.getJSONEncoderPrimShort());
        this.cache.put((Type)((Object)Short[].class), ArraysJSONEncoder.getJSONEncoderShort());
        this.cache.put((Type)((Object)long[].class), ArraysJSONEncoder.getJSONEncoderPrimLong());
        this.cache.put((Type)((Object)Long[].class), ArraysJSONEncoder.getJSONEncoderLong());
        this.cache.put((Type)((Object)byte[].class), ArraysJSONEncoder.getJSONEncoderPrimByte());
        this.cache.put((Type)((Object)Byte[].class), ArraysJSONEncoder.getJSONEncoderByte());
        this.cache.put((Type)((Object)char[].class), ArraysJSONEncoder.getJSONEncoderPrimChar());
        this.cache.put((Type)((Object)Character[].class), ArraysJSONEncoder.getJSONEncoderChar());
        this.cache.put((Type)((Object)float[].class), ArraysJSONEncoder.getJSONEncoderPrimFloat());
        this.cache.put((Type)((Object)Float[].class), ArraysJSONEncoder.getJSONEncoderFloat());
        this.cache.put((Type)((Object)double[].class), ArraysJSONEncoder.getJSONEncoderPrimDouble());
        this.cache.put((Type)((Object)Double[].class), ArraysJSONEncoder.getJSONEncoderDouble());
        this.cache.put((Type)((Object)boolean[].class), ArraysJSONEncoder.getJSONEncoderPrimBool());
        this.cache.put((Type)((Object)Boolean[].class), ArraysJSONEncoder.getJSONEncoderBool());
    }

    public <T> void registerEncoder(Class<T> type, JSONEncoder<T> jsonEncoder) {
        this.cache.put(type, jsonEncoder);
    }

    public <T> JSONEncoder<T> getEncoder(Type type) {
        if (type instanceof ParameterizedType) {
            return this.getEncoder((ParameterizedType)type);
        }
        return this.getEncoder((Class)type);
    }

    public <T> JSONEncoder<T> getEncoder(Class<T> type) {
        JSONEncoder encoder = this.cache.get(type);
        if (encoder != null) {
            return encoder;
        }
        if (type.isArray()) {
            encoder = new ArraysJSONEncoder.GenericJSONEncoder(type);
        } else if (List.class.isAssignableFrom(type)) {
            encoder = new CollectionEncoder.ListClass(type);
        } else if (Map.class.isAssignableFrom(type)) {
            encoder = new CollectionEncoder.MapClass(type);
        } else {
            MappedBy mappedBy = type.getAnnotation(MappedBy.class);
            if (mappedBy != null) {
                if (!mappedBy.encoder().equals(CustomJSONEncoder.NOPJSONEncoder.class)) {
                    encoder = new JSONEncoderWrappedCustomEncoder((CustomJSONEncoder)ClassUtils.newInstance(mappedBy.encoder()));
                } else if (!mappedBy.beanEncoder().equals(CustomBeanJSONEncoder.NOPCustomBeanJSONEncoder.class)) {
                    encoder = (JSONEncoder)ClassUtils.newInstance(mappedBy.beanEncoder());
                }
            }
            if (encoder == null) {
                encoder = new BeanEncoder(type);
            }
        }
        this.cache.putIfAbsent(type, encoder);
        return encoder;
    }

    private <T> JSONEncoder<T> getEncoder(ParameterizedType type) {
        JSONEncoder<?> encoder = this.cache.get(type);
        if (encoder != null) {
            return encoder;
        }
        Class clz = (Class)type.getRawType();
        if (List.class.isAssignableFrom(clz)) {
            encoder = new CollectionEncoder.ListType(type);
        } else if (Map.class.isAssignableFrom(clz)) {
            encoder = new CollectionEncoder.MapType(type);
        }
        if (encoder == null) {
            throw new AtbashException("Only parameterized types of List and Map or custom registered encoders are supported");
        }
        this.cache.putIfAbsent(type, encoder);
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONEncoderFactory getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new JSONEncoderFactory();
                    INSTANCE.initEncoders();
                }
            }
        }
        return INSTANCE;
    }
}

