/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.parser.reader;

import be.atbash.json.JSONArray;
import be.atbash.json.JSONAware;
import be.atbash.json.JSONObject;
import be.atbash.json.parser.reader.JSONEncoder;

public class DefaultJSONEncoder<T>
extends JSONEncoder<T> {
    private static final JSONEncoder<JSONAware> DEFAULT = new DefaultJSONEncoder<JSONAware>();

    private DefaultJSONEncoder() {
    }

    @Override
    public JSONEncoder<JSONAware> startObject(String key) {
        return DEFAULT;
    }

    @Override
    public JSONEncoder<JSONAware> startArray(String key) {
        return DEFAULT;
    }

    @Override
    public T createObject() {
        return (T)new JSONObject();
    }

    @Override
    public Object createArray() {
        return new JSONArray();
    }

    @Override
    public void setValue(T current, String key, Object value) {
        ((JSONObject)current).put(key, value);
    }

    @Override
    public void addValue(Object current, Object value) {
        ((JSONArray)current).add(value);
    }

    public static JSONEncoder<JSONAware> getInstance() {
        return DEFAULT;
    }
}

