/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.parser.reader;

import be.atbash.json.JSONUtil;
import be.atbash.json.parser.CustomJSONEncoder;
import be.atbash.json.parser.MappedBy;
import be.atbash.json.parser.reader.ArraysJSONEncoder;
import be.atbash.json.parser.reader.JSONEncoder;
import be.atbash.json.parser.reader.JSONEncoderFactory;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.ConvertDate;
import net.minidev.asm.FieldFilter;

public class BeanEncoder<T>
extends JSONEncoder<T> {
    private static JSONEncoder<Date> jsonEncoderDate = new ArraysJSONEncoder<Date>(){

        @Override
        public Date convert(Object current) {
            return ConvertDate.convertToDate((Object)current);
        }
    };
    private final Class<T> clz;
    protected final BeansAccess<T> beansAccess;
    private final HashMap<String, Accessor> index;

    public BeanEncoder(Class<T> clz) {
        this.clz = clz;
        this.beansAccess = BeansAccess.get(clz, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
        this.index = this.beansAccess.getMap();
    }

    @Override
    public void setValue(T current, String key, Object value) {
        Accessor accessor = this.index.get(key);
        if (accessor == null) {
            return;
        }
        MappedBy mappedBy = accessor.getType().getAnnotation(MappedBy.class);
        if (mappedBy != null && !mappedBy.encoder().equals(CustomJSONEncoder.NOPJSONEncoder.class)) {
            try {
                value = mappedBy.encoder().newInstance().parse(value);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        this.beansAccess.set(current, key, value);
    }

    @Override
    public Object getValue(T current, String key) {
        return this.beansAccess.get(current, key);
    }

    @Override
    public Type getType(String key) {
        Accessor nfo = this.index.get(key);
        return nfo.getGenericType();
    }

    @Override
    public JSONEncoder<?> startArray(String key) {
        Accessor nfo = this.index.get(key);
        if (nfo == null) {
            throw new RuntimeException("Can not find Array '" + key + "' field in " + this.clz);
        }
        return JSONEncoderFactory.getInstance().getEncoder(nfo.getGenericType());
    }

    @Override
    public JSONEncoder<?> startObject(String key) {
        Accessor f = this.index.get(key);
        if (f == null) {
            throw new RuntimeException("Can not find Object '" + key + "' field in " + this.clz);
        }
        return JSONEncoderFactory.getInstance().getEncoder(f.getGenericType());
    }

    @Override
    public T createObject() {
        return (T)this.beansAccess.newInstance();
    }

    static JSONEncoder<Date> getJsonEncoderDate() {
        return jsonEncoderDate;
    }
}

