/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json;

import be.atbash.json.TypeReference;
import be.atbash.json.parser.JSONParser;
import be.atbash.json.parser.MappedBy;
import be.atbash.json.parser.ParseException;
import be.atbash.json.parser.reader.FakeJSONEncoder;
import be.atbash.json.parser.reader.JSONEncoder;
import be.atbash.json.parser.reader.JSONEncoderFactory;
import be.atbash.json.style.JSONStyle;
import be.atbash.json.writer.JSONWriter;
import be.atbash.json.writer.JSONWriterFactory;
import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.IOException;

@PublicAPI
public class JSONValue {
    private JSONValue() {
    }

    public static <T> T parse(String json, Class<T> mapTo) {
        JSONParser parser = new JSONParser();
        return parser.parse(json, JSONEncoderFactory.getInstance().getEncoder(mapTo));
    }

    public static Object parse(String json, TypeReference mapTo) {
        JSONParser parser = new JSONParser();
        return parser.parse(json, JSONEncoderFactory.getInstance().getEncoder(mapTo.getType()));
    }

    public static Object parse(String json) {
        return new JSONParser().parse(json);
    }

    public static boolean isValidJson(String s) {
        try {
            new JSONParser().parse(s, FakeJSONEncoder.getInstance());
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static <T> void registerWriter(Class<?> cls, JSONWriter<T> writer) {
        JSONWriterFactory.getInstance().registerWriter(writer, cls);
    }

    public static <T> void registerEncoder(Class<T> type, JSONEncoder<T> jsonEncoder) {
        JSONEncoderFactory.getInstance().registerEncoder(type, jsonEncoder);
    }

    public static void writeJSONString(Object value, Appendable out) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        Class<?> clz = value.getClass();
        JSONWriter w = JSONWriterFactory.getInstance().getWriter(clz);
        if (w == null) {
            if (clz.isArray()) {
                w = JSONWriterFactory.getInstance().getArrayWriter();
            } else {
                MappedBy mappedBy;
                w = JSONWriterFactory.getInstance().getWriterByInterface(value.getClass());
                if (w == null && (mappedBy = value.getClass().getAnnotation(MappedBy.class)) != null && !mappedBy.writer().equals(JSONWriter.NOPJSONWriter.class)) {
                    try {
                        w = mappedBy.writer().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new AtbashUnexpectedException((Throwable)e);
                    }
                }
                if (w == null) {
                    w = JSONWriterFactory.getInstance().getBeansWriter();
                }
            }
            JSONWriterFactory.getInstance().registerWriter(w, clz);
        }
        w.writeJSONString(value, out);
    }

    public static String toJSONString(Object value) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value, sb);
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return sb.toString();
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JSONStyle.getDefault().escape(s, sb);
        return sb.toString();
    }
}

