/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json;

import be.atbash.json.JSONValue;
import be.atbash.json.annotate.JsonIgnore;
import be.atbash.json.parser.MappedBy;
import be.atbash.json.style.JSONStyle;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minidev.asm.FieldFilter;

public final class JSONUtil {
    public static final JsonSmartFieldFilter JSON_SMART_FIELD_FILTER = new JsonSmartFieldFilter();

    private JSONUtil() {
    }

    public static Object convertToX(Object obj, Class<?> dest) {
        String asString;
        if (obj == null) {
            return null;
        }
        if (dest.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (dest.isPrimitive()) {
            if (obj instanceof Number) {
                return obj;
            }
            if (dest == Integer.TYPE) {
                return Integer.valueOf(obj.toString());
            }
            if (dest == Short.TYPE) {
                return Short.valueOf(obj.toString());
            }
            if (dest == Long.TYPE) {
                return Long.valueOf(obj.toString());
            }
            if (dest == Byte.TYPE) {
                return Byte.valueOf(obj.toString());
            }
            if (dest == Float.TYPE) {
                return Float.valueOf(obj.toString());
            }
            if (dest == Double.TYPE) {
                return Double.valueOf(obj.toString());
            }
            if (dest == Character.TYPE) {
                String asString2 = dest.toString();
                if (asString2.length() > 0) {
                    return Character.valueOf(asString2.charAt(0));
                }
            } else if (dest == Boolean.TYPE) {
                return obj;
            }
            throw new AtbashUnexpectedException(String.format("Primitive: Can not convert %s to %s", obj.getClass().getName(), dest.getName()));
        }
        if (dest.isEnum()) {
            return Enum.valueOf(dest, obj.toString());
        }
        if (dest == Integer.class) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return Integer.valueOf(obj.toString());
        }
        if (dest == Long.class) {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            return Long.valueOf(obj.toString());
        }
        if (dest == Short.class) {
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            return Short.valueOf(obj.toString());
        }
        if (dest == Byte.class) {
            if (obj instanceof Number) {
                return ((Number)obj).byteValue();
            }
            return Byte.valueOf(obj.toString());
        }
        if (dest == Float.class) {
            if (obj instanceof Number) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            return Float.valueOf(obj.toString());
        }
        if (dest == Double.class) {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return Double.valueOf(obj.toString());
        }
        if (dest == Character.class && (asString = dest.toString()).length() > 0) {
            return Character.valueOf(asString.charAt(0));
        }
        MappedBy mappedBy = dest.getAnnotation(MappedBy.class);
        if (mappedBy != null) {
            try {
                return mappedBy.encoder().newInstance().parse(obj);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        throw new AtbashUnexpectedException(String.format("Object: Can not Convert %s to %s", obj.getClass().getName(), dest.getName()));
    }

    public static void writeJSONKV(String key, Object value, Appendable out) throws IOException {
        if (key == null) {
            out.append("null");
        } else {
            out.append('\"');
            JSONStyle.getDefault().escape(key, out);
            out.append('\"');
        }
        JSONStyle.getDefault().objectEndOfKey(out);
        if (value instanceof String) {
            JSONStyle.getDefault().writeString(out, (String)value);
        } else {
            JSONValue.writeJSONString(value, out);
        }
        JSONStyle.getDefault().objectElmStop(out);
    }

    public static class JsonSmartFieldFilter
    implements FieldFilter {
        public boolean canUse(Field field) {
            JsonIgnore ignore = field.getAnnotation(JsonIgnore.class);
            return ignore == null || !ignore.value();
        }

        public boolean canUse(Field field, Method method) {
            boolean result = this.canUse(field);
            if (!result) {
                return false;
            }
            JsonIgnore ignore = method.getAnnotation(JsonIgnore.class);
            return ignore == null || !ignore.value();
        }

        public boolean canRead(Field field) {
            return true;
        }

        public boolean canWrite(Field field) {
            return true;
        }
    }
}

