/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json;

import be.atbash.json.JSONArray;
import be.atbash.json.JSONAware;
import be.atbash.json.writer.JSONWriterFactory;
import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@PublicAPI
public class JSONObject
extends HashMap<String, Object>
implements JSONAware {
    public JSONObject() {
    }

    public JSONObject(Map<String, ?> map) {
        super(map);
    }

    public JSONObject appendField(String fieldName, Object fieldValue) {
        this.put(fieldName, fieldValue);
        return this;
    }

    public String getAsString(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public Number getAsNumber(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        return Long.valueOf(obj.toString());
    }

    public void writeJSONString(Appendable out) throws IOException {
        JSONObject.writeJSON(this, out);
    }

    public void merge(Object object) {
        JSONObject.merge(this, object);
    }

    @Override
    public String toJSONString() {
        return this.toJSONString(this);
    }

    @Override
    public String toString() {
        return this.toJSONString(this);
    }

    private String toJSONString(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject.writeJSON(map, sb);
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return sb.toString();
    }

    private static void writeJSON(Map<String, ?> map, Appendable out) throws IOException {
        if (map == null) {
            out.append("null");
            return;
        }
        JSONWriterFactory.getInstance().getJsonMapWriter().writeJSONString(map, out);
    }

    public static JSONObject merge(JSONObject object1, Object object2) {
        if (object2 == null) {
            return object1;
        }
        if (object2 instanceof JSONObject) {
            return JSONObject.merge(object1, (JSONObject)object2);
        }
        throw new RuntimeException("JSON merge : Cannot merge JSONObject with " + object2.getClass());
    }

    public static JSONObject merge(JSONObject object1, JSONObject object2) {
        if (object2 == null) {
            return object1;
        }
        for (Map.Entry entry : object1.entrySet()) {
            Object value1 = entry.getValue();
            Object value2 = object2.get(entry.getKey());
            if (value2 == null) continue;
            if (value1 instanceof JSONArray) {
                object1.put(entry.getKey(), JSONArray.merge((JSONArray)value1, value2));
                continue;
            }
            if (value1 instanceof JSONObject) {
                object1.put(entry.getKey(), JSONObject.merge((JSONObject)value1, value2));
                continue;
            }
            if (value1.equals(value2)) continue;
            if (value1.getClass().equals(value2.getClass())) {
                throw new RuntimeException("JSON merge can not merge two " + value1.getClass().getName() + " Object together");
            }
            throw new RuntimeException("JSON merge can not merge " + value1.getClass().getName() + " with " + value2.getClass().getName());
        }
        for (Map.Entry entry : object2.entrySet()) {
            if (object1.containsKey(entry.getKey())) continue;
            object1.put(entry.getKey(), entry.getValue());
        }
        return object1;
    }
}

