/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.json.asm;

import be.atbash.json.asm.Accessor;
import be.atbash.json.asm.BasicFieldFilter;
import be.atbash.json.asm.FieldFilter;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ASMUtil {
    private ASMUtil() {
    }

    static Accessor[] getAccessors(Class<?> type, FieldFilter filter) {
        Class<?> nextClass = type;
        HashMap<String, Accessor> map = new HashMap<String, Accessor>();
        if (filter == null) {
            filter = BasicFieldFilter.SINGLETON;
        }
        while (nextClass != Object.class) {
            Field[] declaredFields;
            for (Field field : declaredFields = nextClass.getDeclaredFields()) {
                Accessor acc;
                String fn = field.getName();
                if (map.containsKey(fn) || !(acc = new Accessor(nextClass, field, filter)).isUsable()) continue;
                map.put(fn, acc);
            }
            nextClass = nextClass.getSuperclass();
        }
        return map.values().toArray(new Accessor[0]);
    }

    static void autoBoxing(MethodVisitor mv, Type fieldType) {
        switch (fieldType.getSort()) {
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
        }
    }

    static Label[] newLabels(int cnt) {
        Label[] r = new Label[cnt];
        for (int i = 0; i < cnt; ++i) {
            r[i] = new Label();
        }
        return r;
    }

    static String getSetterName(String key) {
        int len = key.length();
        char[] b = new char[len + 3];
        b[0] = 115;
        b[1] = 101;
        b[2] = 116;
        char c = key.charAt(0);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        b[3] = c;
        for (int i = 1; i < len; ++i) {
            b[i + 3] = key.charAt(i);
        }
        return new String(b);
    }

    static String getGetterName(String key) {
        int len = key.length();
        char[] b = new char[len + 3];
        b[0] = 103;
        b[1] = 101;
        b[2] = 116;
        char c = key.charAt(0);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        b[3] = c;
        for (int i = 1; i < len; ++i) {
            b[i + 3] = key.charAt(i);
        }
        return new String(b);
    }

    static String getIsName(String key) {
        int len = key.length();
        char[] b = new char[len + 2];
        b[0] = 105;
        b[1] = 115;
        char c = key.charAt(0);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        b[2] = c;
        for (int i = 1; i < len; ++i) {
            b[i + 2] = key.charAt(i);
        }
        return new String(b);
    }
}

