/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.cdi;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.inject.Provider;
import org.apache.geronimo.config.DefaultConfigProvider;
import org.apache.geronimo.config.cdi.ConfigInjectionBean;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigExtension
implements Extension {
    private Config config;
    private static final Map<Type, Type> REPLACED_TYPES = new HashMap<Type, Type>();
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    public void collectConfigProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty configProperty = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    public void registerConfigProducer(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        Set<Type> types = this.filterInjectionPoints(this.injectionPoints, true);
        Set<Type> providerTypes = this.filterInjectionPoints(this.injectionPoints, false);
        types.addAll(providerTypes);
        for (Type type : types) {
            abd.addBean(new ConfigInjectionBean(bm, type));
        }
    }

    private Set<Type> filterInjectionPoints(Set<InjectionPoint> injectionPoints, boolean notProviders) {
        HashSet<Type> result = new HashSet<Type>();
        for (InjectionPoint injectionPoint : injectionPoints) {
            boolean keep;
            if (notProviders) {
                keep = this.isNotprovider(injectionPoint);
            } else {
                boolean bl = keep = !this.isNotprovider(injectionPoint);
            }
            if (!keep) continue;
            if (REPLACED_TYPES.containsKey(injectionPoint.getType())) {
                result.add(REPLACED_TYPES.get(injectionPoint.getType()));
                continue;
            }
            result.add(injectionPoint.getType());
        }
        return result;
    }

    private boolean isNotprovider(InjectionPoint ip) {
        return ip.getType() instanceof Class || ip.getType() instanceof ParameterizedType && ((ParameterizedType)ip.getType()).getRawType() != Provider.class;
    }

    public void validate(@Observes AfterDeploymentValidation add) {
        ArrayList deploymentProblems = new ArrayList();
        this.config = ConfigProvider.getConfig();
    }

    public void shutdown(@Observes BeforeShutdown bsd) {
        DefaultConfigProvider.instance().releaseConfig(this.config);
    }

    static boolean isDefaultUnset(String defaultValue) {
        return defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue");
    }

    static {
        REPLACED_TYPES.put(Double.TYPE, (Type)((Object)Double.class));
        REPLACED_TYPES.put(Integer.TYPE, (Type)((Object)Integer.class));
        REPLACED_TYPES.put(Float.TYPE, (Type)((Object)Float.class));
        REPLACED_TYPES.put(Long.TYPE, (Type)((Object)Long.class));
        REPLACED_TYPES.put(Boolean.TYPE, (Type)((Object)Boolean.class));
    }
}

