/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.geronimo.config.ConfigImpl;
import org.eclipse.microprofile.config.spi.Converter;

@Typed
public class ConfigValueImpl<T> {
    private static final Logger logger = Logger.getLogger(ConfigValueImpl.class.getName());
    private final ConfigImpl config;
    private String keyOriginal;
    private String keyResolved;
    private Class<?> configEntryType = String.class;
    private String[] lookupChain;
    private boolean evaluateVariables = false;
    private long cacheTimeMs = -1L;
    private volatile long reloadAfter = -1L;
    private T lastValue = null;
    private ConfigChanged valueChangeListener;

    public ConfigValueImpl(ConfigImpl config, String key) {
        this.config = config;
        this.keyOriginal = key;
    }

    public <N> ConfigValueImpl<N> as(Class<N> clazz) {
        this.configEntryType = clazz;
        return this;
    }

    public ConfigValueImpl<T> cacheFor(long value, TimeUnit timeUnit) {
        this.cacheTimeMs = timeUnit.toMillis(value);
        return this;
    }

    public ConfigValueImpl<T> evaluateVariables(boolean evaluateVariables) {
        this.evaluateVariables = evaluateVariables;
        return this;
    }

    public ConfigValueImpl<T> withLookupChain(String ... postfixNames) {
        this.lookupChain = postfixNames;
        return this;
    }

    public T get() {
        T val = this.getValue();
        if (val == null) {
            throw new NoSuchElementException("No config value present for key " + this.keyOriginal);
        }
        return val;
    }

    public T getOptional() {
        return this.getValue();
    }

    public ConfigValueImpl<T> onChange(ConfigChanged valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
        return this;
    }

    public List<T> getValueList() {
        String rawList = (String)this.getValue(false);
        ArrayList values = new ArrayList();
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < rawList.length(); ++i) {
            char c = rawList.charAt(i);
            if ('\\' == c) {
                if (i == rawList.length()) {
                    throw new IllegalStateException("incorrect escaping of key " + this.keyOriginal + " value: " + rawList);
                }
                char nextChar = rawList.charAt(i + 1);
                if (nextChar == '\\') {
                    sb.append('\\');
                } else if (nextChar == ',') {
                    sb.append(',');
                }
                ++i;
                continue;
            }
            if (',' == c) {
                this.addListValue(values, sb);
                continue;
            }
            sb.append(c);
        }
        this.addListValue(values, sb);
        return values;
    }

    private void addListValue(List<T> values, StringBuilder sb) {
        String val = sb.toString().trim();
        if (!val.isEmpty()) {
            values.add(this.convert(val));
        }
        sb.setLength(0);
    }

    public T getValue() {
        return this.getValue(true);
    }

    private T getValue(boolean convert) {
        String value;
        long now = -1L;
        if (this.cacheTimeMs > 0L && (now = System.currentTimeMillis()) <= this.reloadAfter) {
            return this.lastValue;
        }
        String valueStr = this.resolveStringValue();
        String string = value = convert ? this.convert(valueStr) : valueStr;
        if (this.valueChangeListener != null && (value != null && !value.equals(this.lastValue) || value == null && this.lastValue != null)) {
            this.valueChangeListener.onValueChange(this.keyOriginal, this.lastValue, value);
        }
        this.lastValue = value;
        if (this.cacheTimeMs > 0L) {
            this.reloadAfter = now + this.cacheTimeMs;
        }
        return (T)value;
    }

    private String resolveStringValue() {
        String value = this.config.getValue(this.keyOriginal);
        if (this.evaluateVariables) {
            String varName;
            int endVar;
            int startVar = 0;
            while ((startVar = value.indexOf("${", startVar)) >= 0 && (endVar = value.indexOf("}", startVar)) > 0 && !(varName = value.substring(startVar + 2, endVar)).isEmpty()) {
                String variableValue = this.config.access(varName).evaluateVariables(true).get();
                if (variableValue != null) {
                    value = value.replace("${" + varName + "}", variableValue);
                }
                ++startVar;
            }
        }
        return value;
    }

    public String getKey() {
        return this.keyOriginal;
    }

    public String getResolvedKey() {
        return this.keyResolved;
    }

    private T convert(String value) {
        if (String.class == this.configEntryType) {
            return (T)value;
        }
        Converter converter = this.config.getConverters().get(this.configEntryType);
        if (converter == null) {
            throw new IllegalStateException("No Converter for type " + this.configEntryType);
        }
        return (T)converter.convert(value);
    }

    static interface ConfigChanged {
        public <T> void onValueChange(String var1, T var2, T var3);
    }
}

