/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.ConfigValueImpl;
import org.apache.geronimo.config.converters.BooleanConverter;
import org.apache.geronimo.config.converters.DateConverter;
import org.apache.geronimo.config.converters.DoubleConverter;
import org.apache.geronimo.config.converters.FloatConverter;
import org.apache.geronimo.config.converters.IntegerConverter;
import org.apache.geronimo.config.converters.LongConverter;
import org.apache.geronimo.config.converters.StringConverter;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@Typed
@Vetoed
public class ConfigImpl
implements Config {
    protected Logger logger = Logger.getLogger(ConfigImpl.class.getName());
    protected List<ConfigSource> configSources = new ArrayList<ConfigSource>();
    protected Map<Type, Converter> converters = new HashMap<Type, Converter>();

    public ConfigImpl() {
        this.registerDefaultConverter();
    }

    private void registerDefaultConverter() {
        this.converters.put((Type)((Object)String.class), StringConverter.INSTANCE);
        this.converters.put((Type)((Object)Boolean.class), BooleanConverter.INSTANCE);
        this.converters.put((Type)((Object)Double.class), DoubleConverter.INSTANCE);
        this.converters.put((Type)((Object)Float.class), FloatConverter.INSTANCE);
        this.converters.put((Type)((Object)Integer.class), IntegerConverter.INSTANCE);
        this.converters.put((Type)((Object)Long.class), LongConverter.INSTANCE);
        this.converters.put((Type)((Object)Date.class), DateConverter.INSTANCE);
    }

    public <T> T getOptionalValue(String propertyName, Class<T> asType) {
        String value = this.getValue(propertyName);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return this.convert(value, asType);
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        String value = this.getValue(propertyName);
        if (value == null || value.isEmpty()) {
            throw new NoSuchElementException("No configured value found for config key " + propertyName);
        }
        return this.convert(value, propertyType);
    }

    public String getValue(String key) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(key);
            if (value == null) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{value, key, configSource.getName()});
            }
            return value;
        }
        return null;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            Converter converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    private <T> Converter getConverter(Class<T> asType) {
        Converter converter = this.converters.get(asType);
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }

    public ConfigValueImpl<String> access(String key) {
        return new ConfigValueImpl<String>(this, key);
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> result = new HashSet<String>();
        for (ConfigSource configSource : this.configSources) {
            result.addAll(configSource.getProperties().keySet());
        }
        return result;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return Collections.unmodifiableList(this.configSources);
    }

    public synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>(this.configSources);
        allConfigSources.addAll(configSourcesToAdd);
        this.configSources = this.sortDescending(allConfigSources);
    }

    public synchronized void addConverter(Converter<?> converter) {
        if (converter == null) {
            return;
        }
        Type targetType = this.getTypeOfConverter(converter.getClass());
        if (targetType == null) {
            throw new IllegalStateException("Converter " + converter.getClass() + " must be a ParameterisedType");
        }
        Converter oldConverter = this.converters.get(targetType);
        if (oldConverter == null || this.getPriority(converter) > this.getPriority(oldConverter)) {
            this.converters.put(targetType, converter);
        }
    }

    private int getPriority(Converter<?> converter) {
        int priority = 100;
        Priority priorityAnnotation = converter.getClass().getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            priority = priorityAnnotation.value();
        }
        return priority;
    }

    public Map<Type, Converter> getConverters() {
        return this.converters;
    }

    protected List<ConfigSource> sortDescending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? -1 : 1;
            }
        });
        return configSources;
    }

    private Type getTypeOfConverter(Class clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be a ParameterisedType");
            }
            return typeArguments[0];
        }
        return this.getTypeOfConverter(clazz.getSuperclass());
    }
}

