/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.config.test;

import be.atbash.config.test.converters.BooleanConverter;
import be.atbash.config.test.converters.DateConverter;
import be.atbash.config.test.converters.DoubleConverter;
import be.atbash.config.test.converters.FloatConverter;
import be.atbash.config.test.converters.IntegerConverter;
import be.atbash.config.test.converters.LongConverter;
import be.atbash.config.test.converters.StringConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class TestConfig
implements Config {
    private static Map<String, String> configValues = new HashMap<String, String>();
    private static Map<Type, Converter> converters = new HashMap<Type, Converter>();

    public static void addConfigValue(String key, String value) {
        configValues.put(key, value);
    }

    public static void resetConfig() {
        configValues.clear();
    }

    public static void registerConverter(Converter<?> converter) {
        if (converter == null) {
            return;
        }
        Type targetType = TestConfig.getTypeOfConverter(converter.getClass());
        if (targetType == null) {
            throw new IllegalStateException("Converter " + converter.getClass() + " must be a ParameterisedType");
        }
        converters.put(targetType, converter);
    }

    public static void registerDefaultConverters() {
        converters.put((Type)((Object)String.class), StringConverter.INSTANCE);
        converters.put((Type)((Object)Boolean.class), BooleanConverter.INSTANCE);
        converters.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        converters.put((Type)((Object)Double.class), DoubleConverter.INSTANCE);
        converters.put(Double.TYPE, DoubleConverter.INSTANCE);
        converters.put((Type)((Object)Float.class), FloatConverter.INSTANCE);
        converters.put(Float.TYPE, FloatConverter.INSTANCE);
        converters.put((Type)((Object)Integer.class), IntegerConverter.INSTANCE);
        converters.put(Integer.TYPE, IntegerConverter.INSTANCE);
        converters.put((Type)((Object)Long.class), LongConverter.INSTANCE);
        converters.put(Long.TYPE, LongConverter.INSTANCE);
        converters.put((Type)((Object)Date.class), DateConverter.INSTANCE);
    }

    public static void deregisterAllConverters() {
        converters.clear();
    }

    private static Type getTypeOfConverter(Class clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be a ParameterisedType");
            }
            return typeArguments[0];
        }
        return TestConfig.getTypeOfConverter(clazz.getSuperclass());
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if (!configValues.containsKey(propertyName)) {
            throw new NoSuchElementException(String.format("Key %s does not exists", propertyName));
        }
        String value = configValues.get(propertyName);
        return this.convert(value, propertyType);
    }

    public <T> T getOptionalValue(String propertyName, Class<T> propertyType) {
        String value = configValues.get(propertyName);
        if (value == null) {
            return null;
        }
        return this.getValue(propertyName, propertyType);
    }

    public Iterable<String> getPropertyNames() {
        return null;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return null;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            Converter converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    private <T> Converter getConverter(Class<T> asType) {
        Converter converter = converters.get(asType);
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }
}

