/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.config.client;

import be.atbash.config.ConfigOptionalValue;
import be.atbash.config.exception.ConfigurationException;
import be.atbash.ee.security.octopus.jwt.decoder.JWTDecoder;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServerConfigSource
implements ConfigSource {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigServerConfigSource.class);
    private static final Pattern WORD_PATTERN = Pattern.compile("\\w*");
    private Map<String, String> properties;

    private void init() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
            String configServerURL = null;
            String application = null;
            try {
                configServerURL = (String)ConfigProvider.getConfig().getValue("config.server.url", String.class);
                application = (String)ConfigProvider.getConfig().getValue("config.server.app", String.class);
            }
            catch (NoSuchElementException e) {
                throw new ConfigurationException(e.getMessage());
            }
            String stage = (String)ConfigOptionalValue.getValue((String)"config.server.stage", String.class);
            this.checkValue(application, true, "config.server.app");
            this.checkValue(stage, false, "config.server.stage");
            WebTarget target = ClientBuilder.newClient().target(this.defineConfigServerEndpoint(configServerURL, application, stage));
            Response response = target.request().buildGet().invoke();
            if (response.getStatus() == 200) {
                String config = (String)response.readEntity(String.class);
                JWTDecoder decoder = new JWTDecoder();
                this.properties.putAll((Map)decoder.decode(config, HashMap.class));
            }
            if (response.getStatus() == 204) {
                throw new ConfigurationException(String.format("Application '%s' not known by the Atbash Config Server", application));
            }
            if (response.getStatus() > 204) {
                throw new AtbashUnexpectedException((String)response.readEntity(String.class));
            }
        }
    }

    private void checkValue(String value, boolean required, String parameterName) {
        if (StringUtils.isEmpty((String)value) && required) {
            throw new ConfigurationException(String.format("parameter '%s' is required", parameterName));
        }
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        if (!WORD_PATTERN.matcher(value).matches()) {
            throw new ConfigurationException(String.format("parameter '%s' can contain only alphabet characters and digits", parameterName));
        }
    }

    private String defineConfigServerEndpoint(String configServerURL, String application, String stage) {
        StringBuilder result = new StringBuilder();
        if (configServerURL.endsWith("/")) {
            result.append(configServerURL).append("config/");
        } else {
            result.append(configServerURL).append("/config/");
        }
        result.append(application);
        if (StringUtils.hasText((String)stage)) {
            result.append("?stage=").append(stage);
        }
        LOG.info(String.format("Reading configuration values from %s", result.toString()));
        return result.toString();
    }

    public Map<String, String> getProperties() {
        this.init();
        return this.properties;
    }

    public Set<String> getPropertyNames() {
        this.init();
        return this.properties.keySet();
    }

    public String getValue(String s) {
        this.init();
        return this.properties.get(s);
    }

    public String getName() {
        return "Octopus Config Server ";
    }

    public int getOrdinal() {
        return 350;
    }
}

