/*
 * Decompiled with CFR 0.152.
 */
package be.adaxisoft.flat;

import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Flat {
    public static final String DEFAULT_DELIMITER = ".";

    private Flat() throws InstantiationException {
        throw new InstantiationException("Instances of this type are forbidden");
    }

    public static String flatten(JSONObject jsonObject) throws JSONException {
        return Flat.flatten(jsonObject, DEFAULT_DELIMITER);
    }

    public static String flatten(String jsonString) throws JSONException {
        return Flat.flatten(jsonString, DEFAULT_DELIMITER);
    }

    public static String flatten(JSONObject jsonObject, String delimiter) throws JSONException {
        StringBuilder sb = new StringBuilder();
        Flat.flatten(sb, null, jsonObject, delimiter);
        String s = "{" + sb.toString() + "}";
        return s;
    }

    public static String flatten(String jsonString, String delimiter) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        return Flat.flatten(jsonObject, delimiter);
    }

    public static JSONObject flattenToJSONObject(String jsonString) throws JSONException {
        String flatJsonString = Flat.flatten(jsonString);
        return new JSONObject(flatJsonString);
    }

    public static JSONObject flattenToJSONObject(JSONObject jsonObject) throws JSONException {
        String flatJsonString = Flat.flatten(jsonObject);
        return new JSONObject(flatJsonString);
    }

    public static JSONObject flattenToJSONObject(String jsonString, String delimiter) throws JSONException {
        String flatJsonString = Flat.flatten(jsonString, delimiter);
        return new JSONObject(flatJsonString);
    }

    public static JSONObject flattenToJSONObject(JSONObject jsonObject, String delimiter) throws JSONException {
        String flatJsonString = Flat.flatten(jsonObject, delimiter);
        return new JSONObject(flatJsonString);
    }

    private static void flatten(StringBuilder flattenedJson, String parent, Object value, String delimiter) throws JSONException {
        if (value instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)value;
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key.contains(delimiter)) {
                    throw new IllegalArgumentException("A key cannot contain the delimiter");
                }
                String hkey = parent == null ? key : parent + delimiter + key;
                Object jval = jsonObject.get(key);
                Flat.flatten(flattenedJson, hkey, jval, delimiter);
                if (!i.hasNext()) continue;
                flattenedJson.append(",");
            }
        } else if (value instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)value;
            for (int i = 0; i < jsonArray.length(); ++i) {
                String hkey = parent == null ? Integer.toString(i) : parent + delimiter + i;
                Object aval = jsonArray.get(i);
                Flat.flatten(flattenedJson, hkey, aval, delimiter);
                if (i >= jsonArray.length() - 1) continue;
                flattenedJson.append(",");
            }
        } else if (value instanceof String) {
            flattenedJson.append("\"").append(parent).append("\"").append(":");
            String s = (String)value;
            flattenedJson.append(JSONObject.quote((String)s));
        } else if (value instanceof Integer) {
            flattenedJson.append("\"").append(parent).append("\"").append(":");
            Integer integer = (Integer)value;
            flattenedJson.append(integer);
        } else if (JSONObject.NULL.equals(value)) {
            flattenedJson.append("\"").append(parent).append("\"").append(":");
            flattenedJson.append("null");
        }
    }

    public static String unflatten(String flatJsonString) throws JSONException {
        return Flat.unflatten(flatJsonString, DEFAULT_DELIMITER);
    }

    public static String unflatten(JSONObject flatJsonObject) throws JSONException {
        return Flat.unflatten(flatJsonObject, DEFAULT_DELIMITER);
    }

    public static String unflatten(String flatJsonString, String delimiter) throws JSONException {
        JSONObject flatJsonObject = new JSONObject(flatJsonString);
        return Flat.unflatten(flatJsonObject, delimiter);
    }

    public static String unflatten(JSONObject flatJsonObject, String delimiter) throws JSONException {
        return Flat.unflattenToJSONObject(flatJsonObject, delimiter).toString();
    }

    public static JSONObject unflattenToJSONObject(String flatJsonObject) throws JSONException {
        return Flat.unflattenToJSONObject(flatJsonObject, DEFAULT_DELIMITER);
    }

    public static JSONObject unflattenToJSONObject(JSONObject flatJsonObject) throws JSONException {
        return Flat.unflattenToJSONObject(flatJsonObject, DEFAULT_DELIMITER);
    }

    public static JSONObject unflattenToJSONObject(String flatJsonString, String delimiter) throws JSONException {
        JSONObject flatJsonObject = new JSONObject(flatJsonString);
        return Flat.unflattenToJSONObject(flatJsonObject, delimiter);
    }

    public static JSONObject unflattenToJSONObject(JSONObject flatJsonObject, String delimiter) throws JSONException {
        JSONObject unflattened = new JSONObject();
        Iterator keyIterator = flatJsonObject.keys();
        while (keyIterator.hasNext()) {
            String flattenedKey = (String)keyIterator.next();
            String[] keys = flattenedKey.split(Pattern.quote(delimiter));
            JSONObject parent = null;
            Object json = unflattened;
            for (int i = 0; i < keys.length; ++i) {
                if (i == keys.length - 1) {
                    Object value = flatJsonObject.get(flattenedKey);
                    if (json instanceof JSONObject) {
                        JSONObject jsonObject = json;
                        jsonObject.put(keys[i], value);
                        continue;
                    }
                    if (!(json instanceof JSONArray)) continue;
                    JSONArray jsonArray = (JSONArray)json;
                    if (Flat.isNumber(keys[i])) {
                        int index = Integer.parseInt(keys[i]);
                        jsonArray.put(index, value);
                        continue;
                    }
                    JSONObject jsonObject = new JSONObject();
                    String parentKeyPrefix = Flat.parentKeyPrefix(keys, delimiter);
                    for (int j = 0; j < jsonArray.length(); ++j) {
                        if (jsonArray.isNull(j) && !flatJsonObject.has(parentKeyPrefix + j)) continue;
                        Object object = jsonArray.get(j);
                        jsonObject.put(Integer.toString(j), object);
                    }
                    if (parent instanceof JSONArray) {
                        JSONArray array = (JSONArray)parent;
                        int index = Integer.parseInt(keys[i - 1]);
                        array.put(index, (Object)jsonObject);
                    } else {
                        JSONObject object = parent;
                        object.put(keys[i - 1], (Object)jsonObject);
                    }
                    jsonObject.put(keys[i], value);
                    continue;
                }
                if (json instanceof JSONObject) {
                    JSONObject jsonObject = json;
                    if (jsonObject.has(keys[i])) {
                        parent = json;
                        json = jsonObject.get(keys[i]);
                        continue;
                    }
                    if (Flat.isNumber(keys[i + 1])) {
                        parent = json;
                        json = new JSONArray();
                        jsonObject.put(keys[i], json);
                        continue;
                    }
                    parent = json;
                    json = new JSONObject();
                    jsonObject.put(keys[i], json);
                    continue;
                }
                if (!(json instanceof JSONArray)) continue;
                JSONArray jsonArray = (JSONArray)json;
                if (Flat.isNumber(keys[i])) {
                    int index = Integer.parseInt(keys[i]);
                    if (!jsonArray.isNull(index)) {
                        parent = json;
                        json = jsonArray.get(index);
                        continue;
                    }
                    if (Flat.isNumber(keys[i + 1])) {
                        parent = json;
                        json = new JSONArray();
                        jsonArray.put(index, json);
                        continue;
                    }
                    parent = json;
                    json = new JSONObject();
                    jsonArray.put(index, json);
                    continue;
                }
                JSONObject jsonObject = Flat.convertJSONArrayToJSONObject(jsonArray);
                if (parent instanceof JSONArray) {
                    JSONArray array = (JSONArray)parent;
                    int index = Integer.parseInt(keys[i - 1]);
                    array.put(index, (Object)jsonObject);
                } else {
                    JSONObject object = parent;
                    object.put(keys[i - 1], (Object)jsonObject);
                }
                if (Flat.isNumber(keys[i + 1])) {
                    parent = json;
                    json = new JSONArray();
                    jsonObject.put(keys[i], json);
                    continue;
                }
                parent = json;
                json = new JSONObject();
                jsonObject.put(keys[i], json);
            }
        }
        return unflattened;
    }

    private static boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static String parentKeyPrefix(String[] keys, String delimiter) {
        String[] keyRoot = Arrays.copyOf(keys, keys.length - 1);
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < keyRoot.length; ++k) {
            sb.append(keyRoot[k]).append(delimiter);
        }
        return sb.toString();
    }

    private static JSONObject convertJSONArrayToJSONObject(JSONArray jsonArray) {
        JSONObject jsonObject = new JSONObject();
        for (int k = 0; k < jsonArray.length(); ++k) {
            if (jsonArray.isNull(k)) continue;
            Object object = jsonArray.get(k);
            jsonObject.put(Integer.toString(k), object);
        }
        return jsonObject;
    }
}

