/*
 * Decompiled with CFR 0.152.
 */
package be.adaxisoft.flat;

import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Flat {
    public static final String DEFAULT_DELIMITER = ".";

    public static String flatten(JSONObject jsonObject) throws JSONException {
        return Flat.flatten(jsonObject, DEFAULT_DELIMITER);
    }

    public static String flatten(String jsonString) throws JSONException {
        return Flat.flatten(jsonString, DEFAULT_DELIMITER);
    }

    public static String flatten(JSONObject jsonObject, String delimiter) throws JSONException {
        String s = "{" + Flat.flatten(null, jsonObject, delimiter) + "}";
        return s;
    }

    public static String flatten(String jsonString, String delimiter) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        return Flat.flatten(jsonObject, delimiter);
    }

    public static JSONObject flattenToJSONObject(String jsonString) throws JSONException {
        String flatJsonString = Flat.flatten(jsonString);
        return new JSONObject(flatJsonString);
    }

    public static JSONObject flattenToJSONObject(JSONObject jsonObject) throws JSONException {
        String flatJsonString = Flat.flatten(jsonObject);
        return new JSONObject(flatJsonString);
    }

    public static JSONObject flattenToJSONObject(String jsonString, String delimiter) throws JSONException {
        String flatJsonString = Flat.flatten(jsonString, delimiter);
        return new JSONObject(flatJsonString);
    }

    public static JSONObject flattenToJSONObject(JSONObject jsonObject, String delimiter) throws JSONException {
        String flatJsonString = Flat.flatten(jsonObject, delimiter);
        return new JSONObject(flatJsonString);
    }

    private static String flatten(String parent, Object value, String delimiter) throws JSONException {
        StringBuilder sb = new StringBuilder();
        if (value instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)value;
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key.contains(delimiter)) {
                    throw new IllegalArgumentException("A key cannot contain the delimiter");
                }
                String hkey = parent == null ? key : String.valueOf(parent) + delimiter + key;
                Object jval = jsonObject.get(key);
                String json = Flat.flatten(hkey, jval, delimiter);
                sb.append(json);
                if (!i.hasNext()) continue;
                sb.append(",");
            }
        } else if (value instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)value;
            int i = 0;
            while (i < jsonArray.length()) {
                String hkey = parent == null ? "" + i : String.valueOf(parent) + delimiter + i;
                Object aval = jsonArray.get(i);
                String json = Flat.flatten(hkey, aval, delimiter);
                sb.append(json);
                if (i < jsonArray.length() - 1) {
                    sb.append(",");
                }
                ++i;
            }
        } else if (value instanceof String) {
            sb.append("\"").append(parent).append("\"").append(":");
            String s = (String)value;
            sb.append(JSONObject.quote((String)s));
        } else if (value instanceof Integer) {
            sb.append("\"").append(parent).append("\"").append(":");
            Integer integer = (Integer)value;
            sb.append(integer);
        }
        return sb.toString();
    }

    public static String unflatten(String flatJsonString) throws JSONException {
        return Flat.unflatten(flatJsonString, DEFAULT_DELIMITER);
    }

    public static String unflatten(JSONObject flatJsonObject) throws JSONException {
        return Flat.unflatten(flatJsonObject, DEFAULT_DELIMITER);
    }

    public static String unflatten(String flatJsonString, String delimiter) throws JSONException {
        JSONObject flatJsonObject = new JSONObject(flatJsonString);
        return Flat.unflatten(flatJsonObject, delimiter);
    }

    public static String unflatten(JSONObject flatJsonObject, String delimiter) throws JSONException {
        return Flat.unflattenToJSONObject(flatJsonObject, delimiter).toString();
    }

    public static JSONObject unflattenToJSONObject(String flatJsonObject) throws JSONException {
        return Flat.unflattenToJSONObject(flatJsonObject, DEFAULT_DELIMITER);
    }

    public static JSONObject unflattenToJSONObject(JSONObject flatJsonObject) throws JSONException {
        return Flat.unflattenToJSONObject(flatJsonObject, DEFAULT_DELIMITER);
    }

    public static JSONObject unflattenToJSONObject(String flatJsonString, String delimiter) throws JSONException {
        JSONObject flatJsonObject = new JSONObject(flatJsonString);
        return Flat.unflattenToJSONObject(flatJsonObject, delimiter);
    }

    public static JSONObject unflattenToJSONObject(JSONObject flatJsonObject, String delimiter) throws JSONException {
        JSONObject decoded = new JSONObject();
        Iterator i = flatJsonObject.keys();
        while (i.hasNext()) {
            String flattenedKey = (String)i.next();
            String[] keys = flattenedKey.split(Pattern.quote(delimiter));
            JSONObject parent = null;
            Object json = decoded;
            int j = 0;
            while (j < keys.length) {
                if (j == keys.length - 1) {
                    Object value = flatJsonObject.get(flattenedKey);
                    if (json instanceof JSONObject) {
                        JSONObject jsonObject = json;
                        jsonObject.put(keys[j], value);
                    } else if (json instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)json;
                        if (Flat.isNumber(keys[j])) {
                            int index = Integer.parseInt(keys[j]);
                            jsonArray.put(index, value);
                        } else {
                            JSONObject jsonObject = new JSONObject();
                            int k = 0;
                            while (k < jsonArray.length()) {
                                String[] keyRoot = Arrays.copyOf(keys, keys.length - 1);
                                StringBuilder sb = new StringBuilder();
                                int l = 0;
                                while (l < keyRoot.length) {
                                    sb.append(keyRoot[l]).append(delimiter);
                                    ++l;
                                }
                                sb.append(k);
                                if (!jsonArray.isNull(k) || flatJsonObject.has(sb.toString())) {
                                    Object object = jsonArray.get(k);
                                    jsonObject.put(Integer.toString(k), object);
                                }
                                ++k;
                            }
                            if (parent instanceof JSONArray) {
                                JSONArray array = (JSONArray)parent;
                                int index = Integer.parseInt(keys[j - 1]);
                                array.put(index, (Object)jsonObject);
                            } else {
                                JSONObject object = parent;
                                object.put(keys[j - 1], (Object)jsonObject);
                            }
                            jsonObject.put(keys[j], value);
                        }
                    }
                } else if (json instanceof JSONObject) {
                    JSONObject jsonObject = json;
                    if (jsonObject.has(keys[j])) {
                        parent = json;
                        json = jsonObject.get(keys[j]);
                        if (!(json instanceof JSONArray) && !(json instanceof JSONObject)) {
                            throw new AssertionError((Object)"Unhandled object type");
                        }
                    } else if (Flat.isNumber(keys[j + 1])) {
                        parent = json;
                        json = new JSONArray();
                        jsonObject.put(keys[j], json);
                    } else {
                        parent = json;
                        json = new JSONObject();
                        jsonObject.put(keys[j], json);
                    }
                } else if (json instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)json;
                    if (Flat.isNumber(keys[j])) {
                        int index = Integer.parseInt(keys[j]);
                        if (!jsonArray.isNull(index)) {
                            parent = json;
                            json = jsonArray.get(index);
                            if (!(json instanceof JSONArray) && !(json instanceof JSONObject)) {
                                throw new AssertionError((Object)"Unhandled object type");
                            }
                        } else if (Flat.isNumber(keys[j + 1])) {
                            parent = json;
                            json = new JSONArray();
                            jsonArray.put(index, json);
                        } else {
                            parent = json;
                            json = new JSONObject();
                            jsonArray.put(index, json);
                        }
                    } else {
                        JSONObject jsonObject = Flat.convertJSONArrayToJSONObject(jsonArray);
                        if (parent instanceof JSONArray) {
                            JSONArray array = (JSONArray)parent;
                            int index = Integer.parseInt(keys[j - 1]);
                            array.put(index, (Object)jsonObject);
                        } else {
                            JSONObject object = parent;
                            object.put(keys[j - 1], (Object)jsonObject);
                        }
                        if (jsonObject.has(keys[j])) {
                            parent = json;
                            json = jsonObject.get(keys[j]);
                            if (!(json instanceof JSONArray) && !(json instanceof JSONObject)) {
                                throw new AssertionError((Object)"Unhandled object type");
                            }
                        } else if (Flat.isNumber(keys[j + 1])) {
                            parent = json;
                            json = new JSONArray();
                            jsonObject.put(keys[j], json);
                        } else {
                            parent = json;
                            json = new JSONObject();
                            jsonObject.put(keys[j], json);
                        }
                    }
                } else {
                    throw new AssertionError((Object)"Unhandled object type");
                }
                ++j;
            }
        }
        return decoded;
    }

    private static boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static JSONObject convertJSONArrayToJSONObject(JSONArray jsonArray) {
        JSONObject jsonObject = new JSONObject();
        int k = 0;
        while (k < jsonArray.length()) {
            if (!jsonArray.isNull(k)) {
                Object object = jsonArray.get(k);
                jsonObject.put(Integer.toString(k), object);
            }
            ++k;
        }
        return jsonObject;
    }
}

