/*
 * Decompiled with CFR 0.152.
 */
package be.adaxisoft.bencode;

import be.adaxisoft.bencode.BEncodedValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BEncoder {
    public static void encode(Object o, OutputStream out) throws IOException, IllegalArgumentException {
        if (o instanceof BEncodedValue) {
            o = ((BEncodedValue)o).getValue();
        }
        if (o instanceof String) {
            BEncoder.encode((String)o, out);
        } else if (o instanceof byte[]) {
            BEncoder.encode((byte[])o, out);
        } else if (o instanceof Number) {
            BEncoder.encode((Number)o, out);
        } else if (o instanceof List) {
            BEncoder.encode((List)o, out);
        } else if (o instanceof Map) {
            BEncoder.encode((Map)o, out);
        } else {
            throw new IllegalArgumentException("Cannot bencode: " + o.getClass());
        }
    }

    public static void encode(String s, OutputStream out) throws IOException {
        byte[] bs = s.getBytes("UTF-8");
        BEncoder.encode(bs, out);
    }

    public static void encode(Number n, OutputStream out) throws IOException {
        out.write(105);
        String s = n.toString();
        out.write(s.getBytes("UTF-8"));
        out.write(101);
    }

    public static void encode(List<BEncodedValue> l, OutputStream out) throws IOException {
        out.write(108);
        for (BEncodedValue value : l) {
            BEncoder.encode(value, out);
        }
        out.write(101);
    }

    public static void encode(byte[] bs, OutputStream out) throws IOException {
        String l = Integer.toString(bs.length);
        out.write(l.getBytes("UTF-8"));
        out.write(58);
        out.write(bs);
    }

    public static void encode(Map<String, BEncodedValue> m, OutputStream out) throws IOException {
        out.write(100);
        Set<String> s = m.keySet();
        ArrayList<String> l = new ArrayList<String>(s);
        Collections.sort(l);
        for (String key : l) {
            BEncodedValue value = m.get(key);
            BEncoder.encode(key, out);
            BEncoder.encode(value, out);
        }
        out.write(101);
    }

    public static ByteBuffer encode(Map<String, BEncodedValue> m) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BEncoder.encode(m, (OutputStream)baos);
        baos.close();
        return ByteBuffer.wrap(baos.toByteArray());
    }
}

