/*
 * Decompiled with CFR 0.152.
 */
package be.adaxisoft.bencode;

import be.adaxisoft.bencode.InvalidBEncodingException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BEncodedValue {
    private final Object value;

    public BEncodedValue(byte[] value) {
        this.value = value;
    }

    public BEncodedValue(String value) throws UnsupportedEncodingException {
        this.value = value.getBytes("UTF-8");
    }

    public BEncodedValue(String value, String enc) throws UnsupportedEncodingException {
        this.value = value.getBytes(enc);
    }

    public BEncodedValue(int value) {
        this.value = new Integer(value);
    }

    public BEncodedValue(long value) {
        this.value = new Long(value);
    }

    public BEncodedValue(Number value) {
        this.value = value;
    }

    public BEncodedValue(List<BEncodedValue> value) {
        this.value = value;
    }

    public BEncodedValue(Map<String, BEncodedValue> value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() throws InvalidBEncodingException {
        return this.getString("UTF-8");
    }

    public String getString(String encoding) throws InvalidBEncodingException {
        try {
            return new String(this.getBytes(), encoding);
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError(uee.toString());
        }
    }

    public byte[] getBytes() throws InvalidBEncodingException {
        try {
            return (byte[])this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public Number getNumber() throws InvalidBEncodingException {
        try {
            return (Number)this.value;
        }
        catch (ClassCastException cce) {
            throw new InvalidBEncodingException(cce.toString());
        }
    }

    public short getShort() throws InvalidBEncodingException {
        return this.getNumber().shortValue();
    }

    public int getInt() throws InvalidBEncodingException {
        return this.getNumber().intValue();
    }

    public long getLong() throws InvalidBEncodingException {
        return this.getNumber().longValue();
    }

    public List<BEncodedValue> getList() throws InvalidBEncodingException {
        if (this.value instanceof ArrayList) {
            return (ArrayList)this.value;
        }
        throw new InvalidBEncodingException("Excepted List<BEvalue> !");
    }

    public Map<String, BEncodedValue> getMap() throws InvalidBEncodingException {
        if (this.value instanceof HashMap) {
            return (Map)this.value;
        }
        throw new InvalidBEncodingException("Expected Map<String, BEValue> !");
    }
}

