/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.Persistent;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.time.Day;
import barsuift.simLife.time.Month;
import barsuift.simLife.time.SimLifeDateState;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.regex.Pattern;

public class SimLifeDate
implements Persistent<SimLifeDateState>,
Publisher {
    private static final MessageFormat STRING_FORMAT = new MessageFormat("{0,number,00}:{1,number,00}:{2,number,000} {3} {4,number,00} {5} {6,number,0000}");
    private static final Pattern spacePattern = Pattern.compile(" ");
    private static final Pattern colonPattern = Pattern.compile(":");
    public static final int MS_PER_SECOND = 1000;
    public static final int SECOND_PER_MINUTE = 60;
    public static final int MINUTE_PER_DAY = 20;
    public static final int DAY_PER_WEEK = 6;
    public static final int WEEK_PER_MONTH = 3;
    public static final int DAY_PER_MONTH = 18;
    public static final int MONTH_PER_YEAR = 4;
    public static final int WEEK_PER_YEAR = 12;
    public static final int DAY_PER_YEAR = 72;
    private static final int MS_FOR_ONE_SECOND = 1000;
    private static final int MS_FOR_ONE_MINUTE = 60000;
    private static final long MS_FOR_ONE_DAY = 1200000L;
    private static final long MS_FOR_ONE_WEEK = 0x6DDD00L;
    private static final long MS_FOR_ONE_MONTH = 21600000L;
    private static final long MS_FOR_ONE_YEAR = 86400000L;
    private final SimLifeDateState state;
    private final BasicPublisher publisher = new BasicPublisher(this);
    private long timeInMillis;
    private int millisOfSecond;
    private int secondOfMinute;
    private int minuteOfDay;
    private Day dayOfWeek;
    private int weekOfMonth;
    private Month monthOfYear;
    private int year;

    public SimLifeDate() {
        this(0L);
    }

    public SimLifeDate(String date) throws ParseException {
        this.setTime(date);
        this.state = new SimLifeDateState(this.getTimeInMillis());
    }

    public SimLifeDate(long millis) {
        this.setTimeInMillis(millis);
        this.computeFields();
        this.state = new SimLifeDateState(millis);
    }

    public SimLifeDate(SimLifeDate copy) {
        this(copy.getTimeInMillis());
    }

    public SimLifeDate(SimLifeDateState dateState) {
        if (dateState == null) {
            throw new IllegalArgumentException("date state is null");
        }
        this.setTimeInMillis(dateState.getValue());
        this.computeFields();
        this.state = dateState;
    }

    @Override
    public SimLifeDateState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.state.setValue(this.getTimeInMillis());
    }

    public long getTimeInMillis() {
        return this.timeInMillis;
    }

    public int getMillisOfSecond() {
        return this.millisOfSecond;
    }

    public int getSecondOfMinute() {
        return this.secondOfMinute;
    }

    public int getMinuteOfDay() {
        return this.minuteOfDay;
    }

    public Day getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getDayOfMonth() {
        return this.dayOfWeek.getIndex() + (this.weekOfMonth - 1) * 6;
    }

    public int getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public Month getMonthOfYear() {
        return this.monthOfYear;
    }

    public int getYear() {
        return this.year;
    }

    private void computeTime() {
        long result = this.year - 1;
        result = result * 4L + (long)this.monthOfYear.getIndex() - 1L;
        result = result * 3L + (long)this.weekOfMonth - 1L;
        result = result * 6L + (long)this.dayOfWeek.getIndex() - 1L;
        result = result * 20L + (long)this.minuteOfDay;
        result = result * 60L + (long)this.secondOfMinute;
        this.timeInMillis = result = result * 1000L + (long)this.millisOfSecond;
        this.setChanged();
        this.notifySubscribers();
    }

    private void computeFields() {
        long absDay = this.timeInMillis / 1200000L;
        int dayOfMonth = (int)(absDay % 18L);
        this.year = (int)(absDay / 72L) + 1;
        this.monthOfYear = Month.values()[(int)(absDay / 18L % 4L)];
        this.weekOfMonth = dayOfMonth / 6 + 1;
        this.dayOfWeek = Day.values()[dayOfMonth % 6];
        this.minuteOfDay = (int)(this.timeInMillis % 1200000L) / 60000;
        this.secondOfMinute = (int)(this.timeInMillis % 60000L) / 1000;
        this.millisOfSecond = (int)(this.timeInMillis % 1000L);
        this.setChanged();
        this.notifySubscribers();
    }

    public synchronized void setTimeInMillis(long millis) {
        this.timeInMillis = millis;
        this.computeFields();
    }

    public synchronized void set(int millisOfSecond, int secondOfMinute, int minuteOfDay, Day dayOfWeek, int weekOfMonth, Month monthOfYear, int year) {
        this.millisOfSecond = millisOfSecond;
        this.secondOfMinute = secondOfMinute;
        this.minuteOfDay = minuteOfDay;
        this.dayOfWeek = dayOfWeek;
        this.weekOfMonth = weekOfMonth;
        this.monthOfYear = monthOfYear;
        this.year = year;
        this.computeTime();
    }

    public synchronized void setMillisOfSecond(int millis) {
        this.millisOfSecond = millis;
        this.computeTime();
    }

    public synchronized void setSecondOfMinute(int seconds) {
        this.secondOfMinute = seconds;
        this.computeTime();
    }

    public synchronized void setMinuteOfDay(int minutes) {
        this.minuteOfDay = minutes;
        this.computeTime();
    }

    public synchronized void setDayOfWeek(Day day) {
        this.dayOfWeek = day;
        this.computeTime();
    }

    public synchronized void setDayOfMonth(int dayOfMonth) {
        this.weekOfMonth = (dayOfMonth - 1) / 6 + 1;
        this.dayOfWeek = Day.values()[(dayOfMonth - 1) % 6];
        this.computeTime();
    }

    public synchronized void setWeekOfMonth(int weeks) {
        this.weekOfMonth = weeks;
        this.computeTime();
    }

    public synchronized void setMonthOfYear(Month month) {
        this.monthOfYear = month;
        this.computeTime();
    }

    public synchronized void setYear(int years) {
        this.year = years;
        this.computeTime();
    }

    public synchronized void addMillis(long millis) {
        this.setTimeInMillis(this.timeInMillis + millis);
    }

    public synchronized void addSeconds(long seconds) {
        this.setTimeInMillis(this.timeInMillis + seconds * 1000L);
    }

    public synchronized void addMinutes(long minutes) {
        this.setTimeInMillis(this.timeInMillis + minutes * 60000L);
    }

    public synchronized void addDays(long days) {
        this.setTimeInMillis(this.timeInMillis + days * 1200000L);
    }

    public synchronized void addWeeks(long weeks) {
        this.setTimeInMillis(this.timeInMillis + weeks * 0x6DDD00L);
    }

    public synchronized void addMonths(long months) {
        this.setTimeInMillis(this.timeInMillis + months * 21600000L);
    }

    public synchronized void addYears(long years) {
        this.setTimeInMillis(this.timeInMillis + years * 86400000L);
    }

    public String formatDate() {
        return STRING_FORMAT.format(new Object[]{this.minuteOfDay, this.secondOfMinute, this.millisOfSecond, this.dayOfWeek, this.getDayOfMonth(), this.monthOfYear, this.year});
    }

    public synchronized void setTime(String date) throws ParseException {
        String[] elements = spacePattern.split(date);
        String minSecMillisec = elements[0];
        String[] minSecElements = colonPattern.split(minSecMillisec);
        this.year = Integer.parseInt(elements[4]);
        this.monthOfYear = Month.valueOf(elements[3].toUpperCase());
        int dayOfMonth = Integer.parseInt(elements[2]);
        this.weekOfMonth = (dayOfMonth - 1) / 6 + 1;
        this.dayOfWeek = Day.values()[(dayOfMonth - 1) % 6];
        Day dayOfWeekFromText = Day.valueOf(elements[1].toUpperCase());
        if (dayOfWeekFromText != this.dayOfWeek) {
            throw new ParseException(date, minSecMillisec.length() + 1);
        }
        this.minuteOfDay = Integer.parseInt(minSecElements[0]);
        this.secondOfMinute = Integer.parseInt(minSecElements[1]);
        this.millisOfSecond = Integer.parseInt(minSecElements[2]);
        this.computeTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.timeInMillis ^ this.timeInMillis >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimLifeDate other = (SimLifeDate)obj;
        return this.timeInMillis == other.timeInMillis;
    }

    public String toString() {
        return this.formatDate();
    }

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    @Override
    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    @Override
    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    @Override
    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    @Override
    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    @Override
    public void setChanged() {
        this.publisher.setChanged();
    }

    @Override
    public void clearChanged() {
        this.publisher.clearChanged();
    }

    @Override
    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    @Override
    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }
}

