/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.SplitConditionalTaskState;
import barsuift.simLife.process.SynchronizedTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConditionalTaskStateFactory {
    private static final int DEFAULT_BOUND = 0;
    private static final int DEFAULT_CYCLE = 1;
    private static final String PROPERTIES_FILE = "barsuift/simLife/process/ConditionalTasks.properties";
    private static final String BOUND_SUFFIX = ".bound";
    private static final String CYCLE_SUFFIX = ".cycle";
    private static final Properties prop = ConditionalTaskStateFactory.loadProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        Properties prop = new Properties();
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(PROPERTIES_FILE);
            prop.load(is);
        }
        catch (IOException e) {
            System.out.println("Unable to open properties file barsuift/simLife/process/ConditionalTasks.properties\n" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.out.println("Unable to close open stream on properties file barsuift/simLife/process/ConditionalTasks.properties");
                }
            }
        }
        return prop;
    }

    public ConditionalTaskState createConditionalTaskState(Class<? extends ConditionalTask> clazz) {
        CyclicConditionState executionCondition = this.createCyclicConditionState(clazz);
        BoundConditionState endingCondition = this.createBoundConditionState(clazz);
        return new ConditionalTaskState(executionCondition, endingCondition);
    }

    public SplitConditionalTaskState createSplitConditionalTaskState(Class<? extends ConditionalTask> clazz) {
        ConditionalTaskState conditionalTask = this.createConditionalTaskState(clazz);
        return new SplitConditionalTaskState(conditionalTask, Speed.DEFAULT_SPEED.getSpeed());
    }

    private BoundConditionState createBoundConditionState(Class<? extends SynchronizedTask> clazz) {
        String boundStr = this.getProperty(clazz.getSimpleName() + BOUND_SUFFIX);
        int bound = boundStr.length() == 0 ? 0 : Integer.parseInt(boundStr);
        int count = 0;
        return new BoundConditionState(bound, count);
    }

    private CyclicConditionState createCyclicConditionState(Class<? extends SynchronizedTask> clazz) {
        String boundStr = this.getProperty(clazz.getSimpleName() + CYCLE_SUFFIX);
        int bound = boundStr.length() == 0 ? 1 : Integer.parseInt(boundStr);
        int count = 0;
        return new CyclicConditionState(bound, count);
    }

    private String getProperty(String key) {
        String property = prop.getProperty(key);
        if (property == null) {
            System.out.println("No value four for key " + key);
            return "";
        }
        return property;
    }
}

