/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.TaskSynchronizer;
import barsuift.simLife.process.Temporizer;
import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTaskSynchronizer<E extends ConditionalTask>
implements TaskSynchronizer<E> {
    private boolean running = false;
    private boolean isStopAsked = false;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Temporizer temporizer;
    private ScheduledFuture<?> temporizerFuture;
    private CyclicBarrier innerBarrier;
    private CyclicBarrier barrierForTasks;
    private final ExecutorService standardThreadPool;
    private final ConcurrentLinkedQueue<E> tasks = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<E> newTasksToSchedule = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<E> tasksToUnschedule = new ConcurrentLinkedQueue();
    private final Publisher publisher = new BasicPublisher(this);

    public AbstractTaskSynchronizer() {
        this.barrierForTasks = new CyclicBarrier(1, this.createBarrierTask());
        this.temporizer = new Temporizer(this.barrierForTasks);
        this.scheduledThreadPool = Executors.newScheduledThreadPool(1);
        this.standardThreadPool = Executors.newCachedThreadPool();
    }

    public void setBarrier(CyclicBarrier barrier) {
        if (this.innerBarrier != null) {
            throw new IllegalStateException("The synchronizer already has a barrier to synchronize on");
        }
        if (barrier == null) {
            throw new IllegalArgumentException("The given barrier is null");
        }
        this.innerBarrier = barrier;
    }

    protected void synchronizeWithOthers() {
        try {
            this.innerBarrier.await();
        }
        catch (InterruptedException e) {
            this.internalStop();
        }
        catch (BrokenBarrierException e) {
            this.internalStop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected Collection<E> getTasks() {
        return this.tasks;
    }

    protected Collection<E> getScheduledTasks() {
        return this.newTasksToSchedule;
    }

    @Override
    public void schedule(E task) {
        this.newTasksToSchedule.add(task);
        task.addSubscriber(this);
    }

    @Override
    public void unschedule(E task) {
        if (!this.newTasksToSchedule.remove(task)) {
            if (!this.tasks.contains(task)) {
                throw new IllegalStateException("The task to unschedule is not acutally scheduled. task=" + task);
            }
            this.tasksToUnschedule.add(task);
        }
        task.deleteSubscriber(this);
    }

    @Override
    public void update(Publisher publisher, Object arg) {
        this.unschedule((ConditionalTask)publisher);
    }

    @Override
    public synchronized void start() {
        this.isStopAsked = false;
        if (this.running) {
            throw new IllegalStateException("The synchronizer is already running");
        }
        this.updateTaskList(false);
        this.running = true;
        this.temporizerFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.temporizer, 0L, this.getTemporizerPeriod(), TimeUnit.MILLISECONDS);
        for (ConditionalTask task : this.tasks) {
            this.standardThreadPool.submit(task);
        }
        this.setChanged();
        this.notifySubscribers();
    }

    protected abstract int getTemporizerPeriod();

    @Override
    public synchronized void stop() {
        if (!this.running) {
            throw new IllegalStateException("The synchronizer is not running");
        }
        this.isStopAsked = true;
    }

    public synchronized void stopAndWait() {
        this.stop();
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    protected boolean isStopAsked() {
        return this.isStopAsked;
    }

    protected void internalStop() {
        if (!this.running) {
            throw new IllegalStateException("The synchronizer is not running");
        }
        this.running = false;
        this.temporizerFuture.cancel(false);
        for (ConditionalTask task : this.tasks) {
            task.stop();
        }
        this.setChanged();
        this.notifySubscribers();
    }

    protected void updateTaskList(boolean startNewTasks) {
        int nbNewTasksToAdd = this.newTasksToSchedule.size();
        int nbTasksToRemove = this.tasksToUnschedule.size();
        if (nbNewTasksToAdd > 0 || nbTasksToRemove > 0) {
            this.barrierForTasks = new CyclicBarrier(this.barrierForTasks.getParties() + nbNewTasksToAdd - nbTasksToRemove, this.createBarrierTask());
            this.tasks.addAll(this.newTasksToSchedule);
            this.tasks.removeAll(this.tasksToUnschedule);
            for (ConditionalTask task : this.tasks) {
                task.changeBarrier(this.barrierForTasks);
            }
            this.temporizer.changeBarrier(this.barrierForTasks);
            while (!this.newTasksToSchedule.isEmpty()) {
                ConditionalTask taskToSchedule = (ConditionalTask)this.newTasksToSchedule.poll();
                if (!startNewTasks) continue;
                this.standardThreadPool.submit(taskToSchedule);
            }
            while (!this.tasksToUnschedule.isEmpty()) {
                ConditionalTask taskToUnschedule = (ConditionalTask)this.tasksToUnschedule.poll();
                if (!taskToUnschedule.isRunning()) continue;
                taskToUnschedule.stop();
            }
        }
    }

    protected abstract Runnable createBarrierTask();

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    @Override
    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    @Override
    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    @Override
    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    @Override
    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    @Override
    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    @Override
    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    @Override
    public void setChanged() {
        this.publisher.setChanged();
    }

    @Override
    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

