/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.process.SynchronizedTask;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public abstract class AbstractSynchronizedTask
implements SynchronizedTask {
    private CyclicBarrier barrier;
    private CyclicBarrier nextBarrier;
    private boolean running = false;
    private boolean isStopAsked;

    protected AbstractSynchronizedTask() {
    }

    @Override
    public void changeBarrier(CyclicBarrier barrier) {
        if (barrier == null) {
            throw new IllegalArgumentException("barrier is null");
        }
        if (this.barrier == null) {
            this.barrier = barrier;
        } else {
            this.nextBarrier = barrier;
        }
    }

    @Override
    public final void run() {
        if (this.barrier == null) {
            throw new IllegalStateException("The barrier is not set");
        }
        if (this.running) {
            throw new IllegalStateException("The process is already running");
        }
        this.isStopAsked = false;
        this.running = true;
        while (!this.isStopAsked) {
            this.executeStep();
            this.switchBarrier();
            try {
                this.barrier.await();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (BrokenBarrierException e) {
                return;
            }
        }
        this.running = false;
    }

    private void switchBarrier() {
        if (this.nextBarrier != null) {
            this.barrier = this.nextBarrier;
            this.nextBarrier = null;
        }
    }

    @Override
    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("The process is not running");
        }
        this.isStopAsked = true;
    }

    public abstract void executeStep();

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

