/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.Persistent;
import barsuift.simLife.condition.SplitBoundCondition;
import barsuift.simLife.condition.SplitCyclicCondition;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.process.AbstractSynchronizedTask;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTaskState;

public abstract class AbstractSplitConditionalTask
extends AbstractSynchronizedTask
implements SplitConditionalTask,
Persistent<SplitConditionalTaskState> {
    private final SplitConditionalTaskState state;
    private int stepSize;
    private final SplitCyclicCondition executionCondition;
    private final SplitBoundCondition endingCondition;
    private final Publisher publisher = new BasicPublisher(this);

    public AbstractSplitConditionalTask(SplitConditionalTaskState state) {
        this.state = state;
        this.stepSize = state.getStepSize();
        this.executionCondition = new SplitCyclicCondition(state.getConditionalTask().getExecutionCondition());
        this.endingCondition = new SplitBoundCondition(state.getConditionalTask().getEndingCondition());
    }

    @Override
    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public final void executeStep() {
        if (this.endingCondition.evaluate(this.stepSize)) {
            this.stop();
            this.setChanged();
            this.notifySubscribers();
        }
        if (this.executionCondition.evaluate(this.stepSize)) {
            this.executeConditionalStep();
        }
    }

    @Override
    public final void executeConditionalStep() {
        this.executeSplitConditionalStep(this.stepSize);
    }

    @Override
    public abstract void executeSplitConditionalStep(int var1);

    @Override
    public SplitConditionalTaskState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.state.setStepSize(this.stepSize);
        this.executionCondition.synchronize();
        this.endingCondition.synchronize();
    }

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    @Override
    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    @Override
    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    @Override
    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    @Override
    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    @Override
    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    @Override
    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    @Override
    public void setChanged() {
        this.publisher.setChanged();
    }

    @Override
    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

