/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.Persistent;
import barsuift.simLife.condition.BoundCondition;
import barsuift.simLife.condition.CyclicCondition;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.process.AbstractSynchronizedTask;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;

public abstract class AbstractConditionalTask
extends AbstractSynchronizedTask
implements ConditionalTask,
Persistent<ConditionalTaskState> {
    private final ConditionalTaskState state;
    private final CyclicCondition executionCondition;
    private final BoundCondition endingCondition;
    private final Publisher publisher = new BasicPublisher(this);

    public AbstractConditionalTask(ConditionalTaskState state) {
        this.state = state;
        this.executionCondition = new CyclicCondition(state.getExecutionCondition());
        this.endingCondition = new BoundCondition(state.getEndingCondition());
    }

    @Override
    public final void executeStep() {
        if (this.endingCondition.evaluate()) {
            this.stop();
            this.setChanged();
            this.notifySubscribers();
        }
        if (this.executionCondition.evaluate()) {
            this.executeConditionalStep();
        }
    }

    @Override
    public abstract void executeConditionalStep();

    @Override
    public ConditionalTaskState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.executionCondition.synchronize();
        this.endingCondition.synchronize();
    }

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    @Override
    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    @Override
    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    @Override
    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    @Override
    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    @Override
    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    @Override
    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    @Override
    public void setChanged() {
        this.publisher.setChanged();
    }

    @Override
    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

