/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.message;

import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import java.util.Vector;

public class BasicPublisher
implements Publisher {
    private boolean changed = false;
    private final Vector<Subscriber> subscribers = new Vector();
    private final Publisher wrappedPublisher;

    public BasicPublisher(Publisher publisher) {
        this.wrappedPublisher = publisher;
    }

    @Override
    public synchronized void addSubscriber(Subscriber subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        if (!this.subscribers.contains(subscriber)) {
            this.subscribers.addElement(subscriber);
        }
    }

    @Override
    public synchronized void deleteSubscriber(Subscriber subscriber) {
        this.subscribers.removeElement(subscriber);
    }

    @Override
    public void notifySubscribers() {
        this.notifySubscribers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySubscribers(Object arg) {
        Object[] arrLocal;
        BasicPublisher basicPublisher = this;
        synchronized (basicPublisher) {
            if (!this.changed) {
                return;
            }
            arrLocal = this.subscribers.toArray();
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((Subscriber)arrLocal[i]).update(this.wrappedPublisher, arg);
        }
    }

    @Override
    public synchronized void deleteSubscribers() {
        this.subscribers.removeAllElements();
    }

    @Override
    public synchronized void setChanged() {
        this.changed = true;
    }

    @Override
    public synchronized void clearChanged() {
        this.changed = false;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.changed;
    }

    @Override
    public synchronized int countSubscribers() {
        return this.subscribers.size();
    }
}

