/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.condition;

import barsuift.simLife.Persistent;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.condition.SplitCondition;

public class SplitCyclicCondition
implements SplitCondition,
Persistent<CyclicConditionState> {
    private final CyclicConditionState state;
    private final int cycle;
    private int count;

    public SplitCyclicCondition(CyclicConditionState state) {
        this.state = state;
        this.cycle = state.getCycle();
        this.count = state.getCount();
    }

    @Override
    public boolean evaluate(int stepSize) {
        this.count += stepSize;
        if (this.count >= this.cycle) {
            this.count %= this.cycle;
            return true;
        }
        return false;
    }

    @Override
    public CyclicConditionState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.state.setCount(this.count);
        this.state.setCycle(this.cycle);
    }
}

