/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.condition;

import barsuift.simLife.Persistent;
import barsuift.simLife.condition.Condition;
import barsuift.simLife.condition.CyclicConditionState;

public class CyclicCondition
implements Condition,
Persistent<CyclicConditionState> {
    private final CyclicConditionState state;
    private final int cycle;
    private int count;

    public CyclicCondition(CyclicConditionState state) {
        this.state = state;
        this.cycle = state.getCycle();
        this.count = state.getCount();
    }

    @Override
    public boolean evaluate() {
        ++this.count;
        if (this.count == this.cycle) {
            this.count = 0;
            return true;
        }
        return false;
    }

    @Override
    public CyclicConditionState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.state.setCount(this.count);
        this.state.setCycle(this.cycle);
    }
}

