/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.condition;

import barsuift.simLife.Persistent;
import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.Condition;

public class BoundCondition
implements Condition,
Persistent<BoundConditionState> {
    private final BoundConditionState state;
    private final int bound;
    private int count;

    public BoundCondition(BoundConditionState state) {
        this.state = state;
        this.bound = state.getBound();
        this.count = state.getCount();
    }

    @Override
    public boolean evaluate() {
        if (this.bound == 0) {
            return false;
        }
        if (this.count < this.bound) {
            ++this.count;
            return this.count >= this.bound;
        }
        return true;
    }

    @Override
    public BoundConditionState getState() {
        this.synchronize();
        return this.state;
    }

    @Override
    public void synchronize() {
        this.state.setCount(this.count);
        this.state.setBound(this.bound);
    }
}

