/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.time.Day;
import barsuift.simLife.time.Month;
import barsuift.simLife.time.SimLifeDate;
import barsuift.simLife.time.SimLifeDateState;
import junit.framework.TestCase;

public class SimLifeDateTest
extends TestCase {
    public void testConstructorString() throws Exception {
        SimLifeDate date = new SimLifeDate("19:59:999 Firday 04 Sprim 0003");
        SimLifeDateTest.assertEquals((String)"19:59:999 Firday 04 Sprim 0003", (String)date.formatDate());
        SimLifeDateTest.assertEquals((long)199199999L, (long)date.getTimeInMillis());
        date = new SimLifeDate("06:13:158 Winday 12 Tom 0001");
        SimLifeDateTest.assertEquals((String)"06:13:158 Winday 12 Tom 0001", (String)date.formatDate());
        SimLifeDateTest.assertEquals((long)78373158L, (long)date.getTimeInMillis());
    }

    public void testConstructorCopy() {
        SimLifeDate date = new SimLifeDate();
        date.setTimeInMillis(199199158L);
        SimLifeDate cal2 = new SimLifeDate(date);
        SimLifeDateTest.assertEquals((Object)date, (Object)cal2);
        SimLifeDateTest.assertEquals((long)199199158L, (long)cal2.getTimeInMillis());
    }

    public void testConstructorLong() {
        SimLifeDate date = new SimLifeDate(199199000L);
        SimLifeDateTest.assertEquals((long)199199000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((String)"19:59:000 Firday 04 Sprim 0003", (String)date.formatDate());
        date = new SimLifeDate(199200001L);
        SimLifeDateTest.assertEquals((long)199200001L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((String)"00:00:001 Thunsday 05 Sprim 0003", (String)date.formatDate());
        date = new SimLifeDate(78373000L);
        SimLifeDateTest.assertEquals((long)78373000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((String)"06:13:000 Winday 12 Tom 0001", (String)date.formatDate());
    }

    public void testConstructorState() {
        SimLifeDateState dateState = new SimLifeDateState();
        dateState.setValue(199199000L);
        SimLifeDate date = new SimLifeDate(dateState);
        SimLifeDateTest.assertEquals((long)199199000L, (long)date.getTimeInMillis());
        try {
            new SimLifeDate((SimLifeDateState)null);
            SimLifeDateTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddWithBasicConstructor() {
        this.internalTestAdd(new SimLifeDate());
    }

    public void testAddWithLongConstructor() {
        this.internalTestAdd(new SimLifeDate(0L));
    }

    public void testAddWithSimLifeDateConstructor() {
        SimLifeDate date = new SimLifeDate();
        this.internalTestAdd(new SimLifeDate(date));
    }

    public void testAddWithStateConstructor() {
        SimLifeDateState dateState = new SimLifeDateState();
        this.internalTestAdd(new SimLifeDate(dateState));
    }

    public void testAddWithStringConstructor() throws Exception {
        this.internalTestAdd(new SimLifeDate("00:00:000 Nosday 01 Wim 0001"));
    }

    public void internalTestAdd(SimLifeDate date) {
        SimLifeDateTest.assertEquals((long)0L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        date.addMillis(1L);
        SimLifeDateTest.assertEquals((long)1L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)1, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        date.addMillis(499L);
        SimLifeDateTest.assertEquals((long)500L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)500, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        date.addMillis(500L);
        SimLifeDateTest.assertEquals((long)1000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)1, (int)date.getSecondOfMinute());
        date.addSeconds(19L);
        SimLifeDateTest.assertEquals((long)20000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)20, (int)date.getSecondOfMinute());
        date.addSeconds(40L);
        SimLifeDateTest.assertEquals((long)60000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        SimLifeDateTest.assertEquals((int)1, (int)date.getMinuteOfDay());
        date.addMinutes(10L);
        SimLifeDateTest.assertEquals((long)660000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        SimLifeDateTest.assertEquals((int)11, (int)date.getMinuteOfDay());
        SimLifeDateTest.assertEquals((int)1, (int)date.getDayOfMonth());
        SimLifeDateTest.assertEquals((Object)Day.NOSDAY, (Object)date.getDayOfWeek());
        date.addMinutes(19L);
        SimLifeDateTest.assertEquals((long)1800000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        SimLifeDateTest.assertEquals((int)10, (int)date.getMinuteOfDay());
        SimLifeDateTest.assertEquals((int)2, (int)date.getDayOfMonth());
        SimLifeDateTest.assertEquals((Object)Day.WATSDAY, (Object)date.getDayOfWeek());
        date.addDays(1L);
        SimLifeDateTest.assertEquals((long)3000000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        SimLifeDateTest.assertEquals((int)10, (int)date.getMinuteOfDay());
        SimLifeDateTest.assertEquals((int)3, (int)date.getDayOfMonth());
        SimLifeDateTest.assertEquals((Object)Day.STOODAY, (Object)date.getDayOfWeek());
        date.addDays(1L);
        SimLifeDateTest.assertEquals((long)4200000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        SimLifeDateTest.assertEquals((int)10, (int)date.getMinuteOfDay());
        SimLifeDateTest.assertEquals((int)4, (int)date.getDayOfMonth());
        SimLifeDateTest.assertEquals((Object)Day.FIRDAY, (Object)date.getDayOfWeek());
        date.addDays(1L);
        SimLifeDateTest.assertEquals((long)5400000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)0, (int)date.getMillisOfSecond());
        SimLifeDateTest.assertEquals((int)0, (int)date.getSecondOfMinute());
        SimLifeDateTest.assertEquals((int)10, (int)date.getMinuteOfDay());
        SimLifeDateTest.assertEquals((int)5, (int)date.getDayOfMonth());
        SimLifeDateTest.assertEquals((Object)Day.THUNSDAY, (Object)date.getDayOfWeek());
        date.addDays(1L);
        SimLifeDateTest.assertEquals((long)6600000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((Object)Day.WINDAY, (Object)date.getDayOfWeek());
        SimLifeDateTest.assertEquals((int)1, (int)date.getWeekOfMonth());
        date.addDays(1L);
        SimLifeDateTest.assertEquals((long)7800000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((Object)Day.NOSDAY, (Object)date.getDayOfWeek());
        SimLifeDateTest.assertEquals((int)2, (int)date.getWeekOfMonth());
        date.addWeeks(1L);
        SimLifeDateTest.assertEquals((long)15000000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((Object)Day.NOSDAY, (Object)date.getDayOfWeek());
        SimLifeDateTest.assertEquals((int)3, (int)date.getWeekOfMonth());
        SimLifeDateTest.assertEquals((Object)Month.WIM, (Object)date.getMonthOfYear());
        date.addWeeks(1L);
        SimLifeDateTest.assertEquals((long)22200000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((Object)Day.NOSDAY, (Object)date.getDayOfWeek());
        SimLifeDateTest.assertEquals((int)1, (int)date.getWeekOfMonth());
        SimLifeDateTest.assertEquals((Object)Month.SPRIM, (Object)date.getMonthOfYear());
        date.addMonths(1L);
        SimLifeDateTest.assertEquals((long)43800000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((Object)Day.NOSDAY, (Object)date.getDayOfWeek());
        SimLifeDateTest.assertEquals((int)1, (int)date.getWeekOfMonth());
        SimLifeDateTest.assertEquals((Object)Month.SUM, (Object)date.getMonthOfYear());
        SimLifeDateTest.assertEquals((int)1, (int)date.getYear());
        date.addMonths(2L);
        SimLifeDateTest.assertEquals((long)87000000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)1, (int)date.getWeekOfMonth());
        SimLifeDateTest.assertEquals((Object)Month.WIM, (Object)date.getMonthOfYear());
        SimLifeDateTest.assertEquals((int)2, (int)date.getYear());
        date.addYears(1L);
        SimLifeDateTest.assertEquals((long)173400000L, (long)date.getTimeInMillis());
        SimLifeDateTest.assertEquals((int)1, (int)date.getWeekOfMonth());
        SimLifeDateTest.assertEquals((Object)Month.WIM, (Object)date.getMonthOfYear());
        SimLifeDateTest.assertEquals((int)3, (int)date.getYear());
    }

    public void testFormatDate() throws Exception {
        SimLifeDate date = new SimLifeDate();
        SimLifeDateTest.assertEquals((String)"00:00:000 Nosday 01 Wim 0001", (String)date.formatDate());
        date.setMillisOfSecond(999);
        SimLifeDateTest.assertEquals((String)"00:00:999 Nosday 01 Wim 0001", (String)date.formatDate());
        date.setSecondOfMinute(59);
        date.setMinuteOfDay(19);
        date.setDayOfWeek(Day.FIRDAY);
        SimLifeDateTest.assertEquals((String)"19:59:999 Firday 04 Wim 0001", (String)date.formatDate());
        date = new SimLifeDate();
        date.setDayOfMonth(15);
        SimLifeDateTest.assertEquals((String)"00:00:000 Stooday 15 Wim 0001", (String)date.formatDate());
        date.setMonthOfYear(Month.TOM);
        SimLifeDateTest.assertEquals((String)"00:00:000 Stooday 15 Tom 0001", (String)date.formatDate());
        date.setYear(12);
        SimLifeDateTest.assertEquals((String)"00:00:000 Stooday 15 Tom 0012", (String)date.formatDate());
        date.setYear(499);
        SimLifeDateTest.assertEquals((String)"00:00:000 Stooday 15 Tom 0499", (String)date.formatDate());
        date.setYear(12345);
        SimLifeDateTest.assertEquals((String)"00:00:000 Stooday 15 Tom 12345", (String)date.formatDate());
        date.setYear(123456789);
        SimLifeDateTest.assertEquals((String)"00:00:000 Stooday 15 Tom 123456789", (String)date.formatDate());
        date = new SimLifeDate();
        date.setDayOfWeek(Day.WINDAY);
        SimLifeDateTest.assertEquals((String)"00:00:000 Winday 06 Wim 0001", (String)date.formatDate());
    }

    public void testDayOfMonth() {
        SimLifeDate date = new SimLifeDate();
        date.setDayOfMonth(1);
        SimLifeDateTest.assertEquals((int)1, (int)date.getDayOfMonth());
        date.setDayOfMonth(2);
        SimLifeDateTest.assertEquals((int)2, (int)date.getDayOfMonth());
        date.setDayOfMonth(3);
        SimLifeDateTest.assertEquals((int)3, (int)date.getDayOfMonth());
        date.setDayOfMonth(4);
        SimLifeDateTest.assertEquals((int)4, (int)date.getDayOfMonth());
        date.setDayOfMonth(5);
        SimLifeDateTest.assertEquals((int)5, (int)date.getDayOfMonth());
        date.setDayOfMonth(6);
        SimLifeDateTest.assertEquals((int)6, (int)date.getDayOfMonth());
        date.setDayOfMonth(7);
        SimLifeDateTest.assertEquals((int)7, (int)date.getDayOfMonth());
        date.setDayOfMonth(8);
        SimLifeDateTest.assertEquals((int)8, (int)date.getDayOfMonth());
        date.setDayOfMonth(12);
        SimLifeDateTest.assertEquals((int)12, (int)date.getDayOfMonth());
        date.setDayOfMonth(13);
        SimLifeDateTest.assertEquals((int)13, (int)date.getDayOfMonth());
        date.setDayOfMonth(17);
        SimLifeDateTest.assertEquals((int)17, (int)date.getDayOfMonth());
        date.setDayOfMonth(18);
        SimLifeDateTest.assertEquals((int)18, (int)date.getDayOfMonth());
    }

    public void testSetTime() throws Exception {
        SimLifeDate date = new SimLifeDate();
        date.setTime("19:59:000 Firday 04 Sprim 0003");
        SimLifeDateTest.assertEquals((String)"19:59:000 Firday 04 Sprim 0003", (String)date.formatDate());
        SimLifeDateTest.assertEquals((long)199199000L, (long)date.getTimeInMillis());
        date.setTime("06:13:001 Winday 12 Tom 0001");
        SimLifeDateTest.assertEquals((String)"06:13:001 Winday 12 Tom 0001", (String)date.formatDate());
        SimLifeDateTest.assertEquals((long)78373001L, (long)date.getTimeInMillis());
    }

    public void testGetState() {
        SimLifeDateState state = new SimLifeDateState(123L);
        SimLifeDate date = new SimLifeDate(state);
        SimLifeDateTest.assertEquals((Object)state, (Object)date.getState());
        SimLifeDateTest.assertSame((Object)state, (Object)date.getState());
        SimLifeDateTest.assertEquals((long)123L, (long)date.getState().getValue());
        date.addMillis(1L);
        SimLifeDateTest.assertEquals((Object)state, (Object)date.getState());
        SimLifeDateTest.assertSame((Object)state, (Object)date.getState());
        SimLifeDateTest.assertEquals((long)124L, (long)date.getState().getValue());
    }

    public void testPublisherAdd() {
        SimLifeDate date = new SimLifeDate();
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)date);
        date.addMillis(1L);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.addMillis(1L);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.addSeconds(53L);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.getTimeInMillis();
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        publisherHelper.reset();
        date.formatDate();
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
    }

    public void testPublisherSet() {
        SimLifeDate date = new SimLifeDate();
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)date);
        date.setMillisOfSecond(1);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.setMillisOfSecond(1);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.setSecondOfMinute(53);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.set(999, 19, 59, Day.NOSDAY, 3, Month.TOM, 99);
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)1, (int)publisherHelper.getUpdateObjects().size());
        SimLifeDateTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        date.getTimeInMillis();
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        publisherHelper.reset();
        date.formatDate();
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        SimLifeDateTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
    }
}

