/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.process.MockSingleSynchronizedTask;
import barsuift.simLife.process.MockSynchronizedTask;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class SynchronizedTaskTest
extends TestCase {
    private MockSingleSynchronizedTask barrierReleaser;
    private MockSynchronizedTask synchroTask;
    private CyclicBarrier barrier;

    protected void setUp() throws Exception {
        super.setUp();
        this.barrier = new CyclicBarrier(2);
        this.synchroTask = new MockSynchronizedTask();
        this.synchroTask.changeBarrier(this.barrier);
        this.barrierReleaser = new MockSingleSynchronizedTask();
        this.barrierReleaser.changeBarrier(this.barrier);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRun() throws InterruptedException {
        new Thread((Runnable)((Object)this.synchroTask)).start();
        Thread.sleep(100L);
        SynchronizedTaskTest.assertTrue((boolean)this.synchroTask.isRunning());
        SynchronizedTaskTest.assertEquals((int)1, (int)this.synchroTask.getNbExecuted());
        try {
            this.synchroTask.run();
            SynchronizedTaskTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.synchroTask.stop();
        this.barrierReleaser.run();
        Thread.sleep(100L);
        SynchronizedTaskTest.assertFalse((boolean)this.synchroTask.isRunning());
        this.synchroTask.resetNbExecuted();
        new Thread((Runnable)((Object)this.synchroTask)).start();
        Thread.sleep(100L);
        SynchronizedTaskTest.assertTrue((boolean)this.synchroTask.isRunning());
        SynchronizedTaskTest.assertEquals((int)1, (int)this.synchroTask.getNbExecuted());
    }

    public void testSetBarrier() throws Exception {
        this.synchroTask.changeBarrier(this.barrier);
        new Thread((Runnable)((Object)this.synchroTask)).start();
        Thread.sleep(100L);
        SynchronizedTaskTest.assertTrue((boolean)this.synchroTask.isRunning());
        this.synchroTask.changeBarrier(this.barrier);
        this.synchroTask.stop();
        this.barrierReleaser.run();
        Thread.sleep(100L);
        SynchronizedTaskTest.assertFalse((boolean)this.synchroTask.isRunning());
        this.synchroTask.changeBarrier(this.barrier);
        try {
            this.synchroTask.changeBarrier(null);
            SynchronizedTaskTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

