/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.process.AbstractConditionalTask;
import barsuift.simLife.process.AbstractSplitConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.ConditionalTaskStateFactory;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTaskState;
import junit.framework.TestCase;

public class ConditionalTaskStateFactoryTest
extends TestCase {
    public void testCreateConditionalTaskState() {
        ConditionalTaskStateFactory factory = new ConditionalTaskStateFactory();
        ConditionalTaskState taskState = factory.createConditionalTaskState(AbstractSplitConditionalTask.class);
        CyclicConditionState executionCondition = taskState.getExecutionCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)5, (int)executionCondition.getCycle());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)executionCondition.getCount());
        BoundConditionState endingCondition = taskState.getEndingCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)10, (int)endingCondition.getBound());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getCount());
        taskState = factory.createConditionalTaskState(AbstractConditionalTask.class);
        executionCondition = taskState.getExecutionCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)2, (int)executionCondition.getCycle());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)executionCondition.getCount());
        endingCondition = taskState.getEndingCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getBound());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getCount());
        taskState = factory.createConditionalTaskState(SplitConditionalTask.class);
        executionCondition = taskState.getExecutionCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)1, (int)executionCondition.getCycle());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)executionCondition.getCount());
        endingCondition = taskState.getEndingCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getBound());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getCount());
    }

    public void testCreateSplitConditionalTaskState() {
        ConditionalTaskStateFactory factory = new ConditionalTaskStateFactory();
        SplitConditionalTaskState splitTaskState = factory.createSplitConditionalTaskState(AbstractSplitConditionalTask.class);
        ConditionalTaskStateFactoryTest.assertEquals((int)1, (int)splitTaskState.getStepSize());
        ConditionalTaskState taskState = splitTaskState.getConditionalTask();
        CyclicConditionState executionCondition = taskState.getExecutionCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)5, (int)executionCondition.getCycle());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)executionCondition.getCount());
        BoundConditionState endingCondition = taskState.getEndingCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)10, (int)endingCondition.getBound());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getCount());
        splitTaskState = factory.createSplitConditionalTaskState(AbstractConditionalTask.class);
        ConditionalTaskStateFactoryTest.assertEquals((int)1, (int)splitTaskState.getStepSize());
        taskState = splitTaskState.getConditionalTask();
        executionCondition = taskState.getExecutionCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)2, (int)executionCondition.getCycle());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)executionCondition.getCount());
        endingCondition = taskState.getEndingCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getBound());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getCount());
        splitTaskState = factory.createSplitConditionalTaskState(SplitConditionalTask.class);
        ConditionalTaskStateFactoryTest.assertEquals((int)1, (int)splitTaskState.getStepSize());
        taskState = splitTaskState.getConditionalTask();
        executionCondition = taskState.getExecutionCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)1, (int)executionCondition.getCycle());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)executionCondition.getCount());
        endingCondition = taskState.getEndingCondition();
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getBound());
        ConditionalTaskStateFactoryTest.assertEquals((int)0, (int)endingCondition.getCount());
    }
}

