/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.MockSingleSynchronizedTask;
import barsuift.simLife.process.MockSplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTaskState;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class AbstractSplitConditionalTaskTest
extends TestCase {
    private MockSplitConditionalTask splitTask;
    private SplitConditionalTaskState state;
    private MockSingleSynchronizedTask barrierReleaser;

    protected void setUp() throws Exception {
        super.setUp();
        CyclicBarrier barrier = new CyclicBarrier(2);
        CyclicConditionState executionCondition = new CyclicConditionState(3, 0);
        BoundConditionState endingCondition = new BoundConditionState(60, 6);
        ConditionalTaskState conditionalTaskState = new ConditionalTaskState(executionCondition, endingCondition);
        this.state = new SplitConditionalTaskState(conditionalTaskState, 2);
        this.barrierReleaser = new MockSingleSynchronizedTask();
        this.barrierReleaser.changeBarrier(barrier);
        this.splitTask = new MockSplitConditionalTask(this.state);
        this.splitTask.changeBarrier(barrier);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRun() throws Exception {
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)this.splitTask);
        new Thread((Runnable)((Object)this.splitTask)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)2, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)8, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        try {
            this.splitTask.run();
            AbstractSplitConditionalTaskTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.splitTask.stop();
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertFalse((boolean)this.splitTask.isRunning());
        new Thread((Runnable)((Object)this.splitTask)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)1, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)2, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)1, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)10, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)2, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)4, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)12, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        this.splitTask.setStepSize(3);
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)3, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)7, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)15, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)4, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)10, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)18, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        this.splitTask.setStepSize(20);
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)5, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)30, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)2, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)38, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)6, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)50, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)1, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)58, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        this.splitTask.setStepSize(1);
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)6, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)50, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)2, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)59, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertTrue((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)7, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)51, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)60, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertFalse((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)7, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)51, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)60, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertFalse((boolean)this.splitTask.isRunning());
        AbstractSplitConditionalTaskTest.assertEquals((int)7, (int)this.splitTask.getNbExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)51, (int)this.splitTask.getNbIncrementExecuted());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)60, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
    }

    public void testGetState() throws InterruptedException {
        AbstractSplitConditionalTaskTest.assertEquals((Object)this.state, (Object)this.splitTask.getState());
        AbstractSplitConditionalTaskTest.assertSame((Object)this.state, (Object)this.splitTask.getState());
        AbstractSplitConditionalTaskTest.assertEquals((int)0, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)6, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
        new Thread((Runnable)((Object)this.splitTask)).start();
        Thread.sleep(100L);
        AbstractSplitConditionalTaskTest.assertEquals((Object)this.state, (Object)this.splitTask.getState());
        AbstractSplitConditionalTaskTest.assertSame((Object)this.state, (Object)this.splitTask.getState());
        AbstractSplitConditionalTaskTest.assertEquals((int)2, (int)this.splitTask.getState().getConditionalTask().getExecutionCondition().getCount());
        AbstractSplitConditionalTaskTest.assertEquals((int)8, (int)this.splitTask.getState().getConditionalTask().getEndingCondition().getCount());
    }
}

