/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.MockConditionalTask;
import barsuift.simLife.process.MockSingleSynchronizedTask;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class AbstractConditionalTaskTest
extends TestCase {
    private MockConditionalTask conditionalRun;
    private ConditionalTaskState state;
    private MockSingleSynchronizedTask barrierReleaser;

    protected void setUp() throws Exception {
        super.setUp();
        CyclicBarrier barrier = new CyclicBarrier(2);
        CyclicConditionState executionConditionState = new CyclicConditionState(3, 0);
        BoundConditionState endingConditionState = new BoundConditionState(5, 0);
        this.state = new ConditionalTaskState(executionConditionState, endingConditionState);
        this.barrierReleaser = new MockSingleSynchronizedTask();
        this.barrierReleaser.changeBarrier(barrier);
        this.conditionalRun = new MockConditionalTask(this.state);
        this.conditionalRun.changeBarrier(barrier);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRun() throws Exception {
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)this.conditionalRun);
        new Thread((Runnable)((Object)this.conditionalRun)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertTrue((boolean)this.conditionalRun.isRunning());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)this.conditionalRun.getNbExecuted());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        try {
            this.conditionalRun.run();
            AbstractConditionalTaskTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.conditionalRun.stop();
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertFalse((boolean)this.conditionalRun.isRunning());
        new Thread((Runnable)((Object)this.conditionalRun)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertTrue((boolean)this.conditionalRun.isRunning());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)this.conditionalRun.getNbExecuted());
        AbstractConditionalTaskTest.assertEquals((int)2, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)2, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertTrue((boolean)this.conditionalRun.isRunning());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getNbExecuted());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)3, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertTrue((boolean)this.conditionalRun.isRunning());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getNbExecuted());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)4, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertTrue((boolean)this.conditionalRun.isRunning());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getNbExecuted());
        AbstractConditionalTaskTest.assertEquals((int)2, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)5, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        AbstractConditionalTaskTest.assertEquals(null, (Object)publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        new Thread((Runnable)((Object)this.barrierReleaser)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertFalse((boolean)this.conditionalRun.isRunning());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getNbExecuted());
        AbstractConditionalTaskTest.assertEquals((int)2, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)5, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.nbUpdated());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)publisherHelper.getUpdateObjects().size());
    }

    public void testGetState() throws InterruptedException {
        AbstractConditionalTaskTest.assertEquals((Object)this.state, (Object)this.conditionalRun.getState());
        AbstractConditionalTaskTest.assertSame((Object)this.state, (Object)this.conditionalRun.getState());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)0, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
        new Thread((Runnable)((Object)this.conditionalRun)).start();
        Thread.sleep(100L);
        AbstractConditionalTaskTest.assertEquals((Object)this.state, (Object)this.conditionalRun.getState());
        AbstractConditionalTaskTest.assertSame((Object)this.state, (Object)this.conditionalRun.getState());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getState().getEndingCondition().getCount());
        AbstractConditionalTaskTest.assertEquals((int)1, (int)this.conditionalRun.getState().getExecutionCondition().getCount());
    }
}

