/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.condition;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.SplitBoundCondition;
import junit.framework.TestCase;

public class SplitBoundConditionTest
extends TestCase {
    private SplitBoundCondition condition;
    private BoundConditionState state;

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpFromParams(7, 2);
    }

    private void setUpFromParams(int bound, int count) {
        this.state = new BoundConditionState(bound, count);
        this.condition = new SplitBoundCondition(this.state);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.state = null;
        this.condition = null;
    }

    public void testEvaluate0() {
        this.setUpFromParams(0, 0);
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
    }

    public void testEvaluate1() {
        this.setUpFromParams(1, 0);
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
    }

    public void testEvaluate2() {
        this.setUpFromParams(2, 0);
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
    }

    public void testEvaluate3() {
        this.setUpFromParams(4, 0);
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
    }

    public void testEvaluate4() {
        this.setUpFromParams(7, 2);
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertFalse((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
        SplitBoundConditionTest.assertTrue((boolean)this.condition.evaluate(2));
    }

    public void testGetState() throws InterruptedException {
        SplitBoundConditionTest.assertEquals((Object)this.state, (Object)this.condition.getState());
        SplitBoundConditionTest.assertSame((Object)this.state, (Object)this.condition.getState());
        SplitBoundConditionTest.assertEquals((int)2, (int)this.condition.getState().getCount());
        SplitBoundConditionTest.assertEquals((int)7, (int)this.condition.getState().getBound());
        this.condition.evaluate(2);
        SplitBoundConditionTest.assertEquals((Object)this.state, (Object)this.condition.getState());
        SplitBoundConditionTest.assertSame((Object)this.state, (Object)this.condition.getState());
        SplitBoundConditionTest.assertEquals((int)4, (int)this.condition.getState().getCount());
        SplitBoundConditionTest.assertEquals((int)7, (int)this.condition.getState().getBound());
    }
}

